/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiContextMenu } from './context_menu';
export { EuiContextMenuPanel } from './context_menu_panel';
export { EuiContextMenuItem } from './context_menu_item';

try {
  EuiContextMenu.__docgenInfo = {
    description: '',
    displayName: 'EuiContextMenu',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      panels: {
        defaultValue: null,
        description: '',
        name: 'panels',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiContextMenuPanelDescriptor[]'
        }
      },
      initialPanelId: {
        defaultValue: null,
        description: '',
        name: 'initialPanelId',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiContextMenuPanel.__docgenInfo = {
    description: '',
    displayName: 'EuiContextMenuPanel',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hasFocus: {
        defaultValue: null,
        description: '',
        name: 'hasFocus',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      initialFocusedItemIndex: {
        defaultValue: null,
        description: '',
        name: 'initialFocusedItemIndex',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      items: {
        defaultValue: null,
        description: '',
        name: 'items',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'ReactElement[]'
        }
      },
      onClose: {
        defaultValue: null,
        description: '',
        name: 'onClose',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'NoArgCallback<void>'
        }
      },
      onHeightChange: {
        defaultValue: null,
        description: '',
        name: 'onHeightChange',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'EuiContextMenuPanelHeightChangeHandler'
        }
      },
      onTransitionComplete: {
        defaultValue: null,
        description: '',
        name: 'onTransitionComplete',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'NoArgCallback<void>'
        }
      },
      onUseKeyboardToNavigate: {
        defaultValue: null,
        description: '',
        name: 'onUseKeyboardToNavigate',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'NoArgCallback<void>'
        }
      },
      showNextPanel: {
        defaultValue: null,
        description: '',
        name: 'showNextPanel',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'EuiContextMenuPanelShowPanelCallback'
        }
      },
      showPreviousPanel: {
        defaultValue: null,
        description: '',
        name: 'showPreviousPanel',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'NoArgCallback<void>'
        }
      },
      title: {
        defaultValue: null,
        description: '',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      transitionDirection: {
        defaultValue: null,
        description: '',
        name: 'transitionDirection',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiContextMenuPanelTransitionDirection',
          value: [{
            value: '"next"'
          }, {
            value: '"previous"'
          }]
        }
      },
      transitionType: {
        defaultValue: null,
        description: '',
        name: 'transitionType',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiContextMenuPanelTransitionType',
          value: [{
            value: '"in"'
          }, {
            value: '"out"'
          }]
        }
      },
      watchedItemProps: {
        defaultValue: null,
        description: '',
        name: 'watchedItemProps',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_panel.tsx',
          name: 'EuiContextMenuPanelProps'
        },
        required: false,
        type: {
          name: 'string[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiContextMenuItem.__docgenInfo = {
    description: '',
    displayName: 'EuiContextMenuItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'EuiContextMenuItemIcon'
        }
      },
      hasPanel: {
        defaultValue: null,
        description: '',
        name: 'hasPanel',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: '(event: any) => void'
        }
      },
      buttonRef: {
        defaultValue: null,
        description: '',
        name: 'buttonRef',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'Ref<HTMLButtonElement>'
        }
      },
      toolTipContent: {
        defaultValue: null,
        description: 'Required if using a tooltip. Add an optional tooltip on hover',
        name: 'toolTipContent',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      toolTipTitle: {
        defaultValue: null,
        description: 'Optional title for the tooltip',
        name: 'toolTipTitle',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      toolTipPosition: {
        defaultValue: null,
        description: 'Dictates the position of the tooltip.',
        name: 'toolTipPosition',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      layoutAlign: {
        defaultValue: null,
        description: 'How to align icon with content of button',
        name: 'layoutAlign',
        parent: {
          fileName: 'eui/src/components/context_menu/context_menu_item.tsx',
          name: 'EuiContextMenuItemProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiContextMenuItemLayoutAlignment',
          value: [{
            value: '"top"'
          }, {
            value: '"bottom"'
          }, {
            value: '"center"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}