/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiControlBar } from './control_bar';

try {
  EuiControlBar.__docgenInfo = {
    description: '',
    displayName: 'EuiControlBar',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      showContent: {
        defaultValue: null,
        description: 'Show or hide the content area containing the `children`',
        name: 'showContent',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      controls: {
        defaultValue: null,
        description: 'An array of controls, actions, and layout spacers to display.\nAccepts `\'button\' | \'tab\' | \'breadcrumbs\' | \'text\' | \'icon\' | \'spacer\' | \'divider\'`',
        name: 'controls',
        parent: undefined,
        required: true,
        type: {
          name: '((DisambiguateSet<(DisambiguateSet<(DisambiguateSet<(DisambiguateSet<(DisambiguateSet<ButtonControlProps, (DisambiguateSet<BreadcrumbControl, TabControl> & TabControl) | (DisambiguateSet<...> & BreadcrumbControl)> & DisambiguateSet<...> & TabControl) | (DisambiguateSet<...> & ... 1 more ... & BreadcrumbControl) | (D...'
        }
      },
      size: {
        defaultValue: null,
        description: 'The default height of the content area.',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }]
        }
      },
      maxHeight: {
        defaultValue: null,
        description: 'Customize the max height.\nBest when used with `size=l` as this will ensure the actual height equals the max height set.',
        name: 'maxHeight',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      },
      leftOffset: {
        defaultValue: null,
        description: 'Set the offset from the left side of the screen.',
        name: 'leftOffset',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      },
      rightOffset: {
        defaultValue: null,
        description: 'Set the offset from the left side of the screen.',
        name: 'rightOffset',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      },
      showOnMobile: {
        defaultValue: null,
        description: 'The control bar is hidden on mobile by default. Use the `showOnMobile` prop to force it\'s display on mobile screens.\nYou\'ll need to ensure that the content you place into the bar renders as expected on mobile.',
        name: 'showOnMobile',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      position: {
        defaultValue: null,
        description: 'By default EuiControlBar will live in a portal, fixed position to the browser window.\nChange the position of the bar to live inside a container and be positioned against its parent.',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"fixed" | "absolute" | "relative"',
          value: [{
            value: '"fixed"'
          }, {
            value: '"absolute"'
          }, {
            value: '"relative"'
          }]
        }
      },
      bodyClassName: {
        defaultValue: null,
        description: 'Optional class applied to the body used when `position = fixed`',
        name: 'bodyClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      landmarkHeading: {
        defaultValue: null,
        description: 'Customize the screen reader heading that helps users find this control. Default is "Page level controls".',
        name: 'landmarkHeading',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}