function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from "prop-types";
import { copyToClipboard } from '../../services';
import { EuiToolTip } from '../tool_tip';
export var EuiCopy =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiCopy, _Component);

  function EuiCopy(props) {
    var _this;

    _classCallCheck(this, EuiCopy);

    _this = _possibleConstructorReturn(this, _getPrototypeOf(EuiCopy).call(this, props));

    _defineProperty(_assertThisInitialized(_this), "copy", function () {
      var isCopied = copyToClipboard(_this.props.textToCopy);

      if (isCopied) {
        _this.setState({
          tooltipText: _this.props.afterMessage
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "resetTooltipText", function () {
      _this.setState({
        tooltipText: _this.props.beforeMessage
      });
    });

    _this.state = {
      tooltipText: _this.props.beforeMessage
    };
    return _this;
  }

  _createClass(EuiCopy, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          textToCopy = _this$props.textToCopy,
          beforeMessage = _this$props.beforeMessage,
          afterMessage = _this$props.afterMessage,
          rest = _objectWithoutProperties(_this$props, ["children", "textToCopy", "beforeMessage", "afterMessage"]);

      return (// See `src/components/tool_tip/tool_tip.js` for explaination of below eslint-disable
        // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
        React.createElement(EuiToolTip, _extends({
          content: this.state.tooltipText,
          onMouseOut: this.resetTooltipText
        }, rest), children(this.copy))
      );
    }
  }]);

  return EuiCopy;
}(Component);

_defineProperty(EuiCopy, "defaultProps", {
  afterMessage: 'Copied'
});

EuiCopy.propTypes = {
  /**
     * Text that will be copied to clipboard when copy function is executed.
     */
  textToCopy: PropTypes.string.isRequired,

  /**
     * Tooltip message displayed before copy function is called.
     */
  beforeMessage: PropTypes.node,

  /**
     * Tooltip message displayed after copy function is called that lets the user know that
     * 'textToCopy' has been copied to the clipboard.
     */
  afterMessage: PropTypes.node,

  /**
     * Function that must return a component. First argument is 'copy' function.
     * Use your own logic to create the component that users interact with when triggering copy.
     */
  children: PropTypes.func.isRequired,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};

try {
  EuiCopy.__docgenInfo = {
    description: '',
    displayName: 'EuiCopy',
    methods: [],
    props: {
      textToCopy: {
        defaultValue: null,
        description: 'Text that will be copied to clipboard when copy function is executed.',
        name: 'textToCopy',
        parent: {
          fileName: 'eui/src/components/copy/copy.tsx',
          name: 'EuiCopyProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      beforeMessage: {
        defaultValue: null,
        description: 'Tooltip message displayed before copy function is called.',
        name: 'beforeMessage',
        parent: {
          fileName: 'eui/src/components/copy/copy.tsx',
          name: 'EuiCopyProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      afterMessage: {
        defaultValue: {
          value: 'Copied'
        },
        description: 'Tooltip message displayed after copy function is called that lets the user know that\n\'textToCopy\' has been copied to the clipboard.',
        name: 'afterMessage',
        parent: {
          fileName: 'eui/src/components/copy/copy.tsx',
          name: 'EuiCopyProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      children: {
        defaultValue: null,
        description: 'Function that must return a component. First argument is \'copy\' function.\nUse your own logic to create the component that users interact with when triggering copy.',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/copy/copy.tsx',
          name: 'EuiCopyProps'
        },
        required: true,
        type: {
          name: '(copy: () => void) => ReactElement'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      position: {
        defaultValue: null,
        description: 'Suggested position. If there is not enough room for it this will be changed.',
        name: 'position',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      id: {
        defaultValue: null,
        description: 'Unless you provide one, this will be randomly generated.',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      title: {
        defaultValue: null,
        description: 'An optional title for your tooltip.',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onMouseOut: {
        defaultValue: null,
        description: 'If supplied, called when mouse movement causes the tool tip to be\nhidden.',
        name: 'onMouseOut',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLSpanElement, MouseEvent>) => void'
        }
      },
      anchorClassName: {
        defaultValue: null,
        description: 'Passes onto the the trigger.',
        name: 'anchorClassName',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      content: {
        defaultValue: null,
        description: 'The main content of your tooltip.',
        name: 'content',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      delay: {
        defaultValue: null,
        description: 'Delay before showing tooltip. Good for repeatable items.',
        name: 'delay',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipDelay',
          value: [{
            value: '"regular"'
          }, {
            value: '"long"'
          }]
        }
      }
    },
    extends: []
  };
} catch (e) {}