/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiCopy } from './copy';

try {
  EuiCopy.__docgenInfo = {
    description: '',
    displayName: 'EuiCopy',
    methods: [],
    props: {
      textToCopy: {
        defaultValue: null,
        description: 'Text that will be copied to clipboard when copy function is executed.',
        name: 'textToCopy',
        parent: {
          fileName: 'eui/src/components/copy/copy.tsx',
          name: 'EuiCopyProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      beforeMessage: {
        defaultValue: null,
        description: 'Tooltip message displayed before copy function is called.',
        name: 'beforeMessage',
        parent: {
          fileName: 'eui/src/components/copy/copy.tsx',
          name: 'EuiCopyProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      afterMessage: {
        defaultValue: null,
        description: 'Tooltip message displayed after copy function is called that lets the user know that\n\'textToCopy\' has been copied to the clipboard.',
        name: 'afterMessage',
        parent: {
          fileName: 'eui/src/components/copy/copy.tsx',
          name: 'EuiCopyProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      children: {
        defaultValue: null,
        description: 'Function that must return a component. First argument is \'copy\' function.\nUse your own logic to create the component that users interact with when triggering copy.',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/copy/copy.tsx',
          name: 'EuiCopyProps'
        },
        required: true,
        type: {
          name: '(copy: () => void) => ReactElement'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      position: {
        defaultValue: null,
        description: 'Suggested position. If there is not enough room for it this will be changed.',
        name: 'position',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      id: {
        defaultValue: null,
        description: 'Unless you provide one, this will be randomly generated.',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      title: {
        defaultValue: null,
        description: 'An optional title for your tooltip.',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onMouseOut: {
        defaultValue: null,
        description: 'If supplied, called when mouse movement causes the tool tip to be\nhidden.',
        name: 'onMouseOut',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLSpanElement, MouseEvent>) => void'
        }
      },
      anchorClassName: {
        defaultValue: null,
        description: 'Passes onto the the trigger.',
        name: 'anchorClassName',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      content: {
        defaultValue: null,
        description: 'The main content of your tooltip.',
        name: 'content',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      delay: {
        defaultValue: null,
        description: 'Delay before showing tooltip. Good for repeatable items.',
        name: 'delay',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipDelay',
          value: [{
            value: '"regular"'
          }, {
            value: '"long"'
          }]
        }
      }
    },
    extends: []
  };
} catch (e) {}