/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiDescriptionList } from './description_list';
export { EuiDescriptionListTitle } from './description_list_title';
export { EuiDescriptionListDescription } from './description_list_description';

try {
  EuiDescriptionList.__docgenInfo = {
    description: '',
    displayName: 'EuiDescriptionList',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      listItems: {
        defaultValue: null,
        description: '',
        name: 'listItems',
        parent: {
          fileName: 'eui/src/components/description_list/description_list.tsx',
          name: 'EuiDescriptionListProps'
        },
        required: false,
        type: {
          name: '{ title: ReactNode; description: ReactNode; }[]'
        }
      },
      align: {
        defaultValue: null,
        description: 'Text alignment',
        name: 'align',
        parent: {
          fileName: 'eui/src/components/description_list/description_list.tsx',
          name: 'EuiDescriptionListProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"left" | "center"',
          value: [{
            value: '"left"'
          }, {
            value: '"center"'
          }]
        }
      },
      compressed: {
        defaultValue: null,
        description: 'Smaller text and condensed spacing',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/description_list/description_list.tsx',
          name: 'EuiDescriptionListProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      textStyle: {
        defaultValue: null,
        description: 'How should the content be styled, by default\nthis will emphasize the title',
        name: 'textStyle',
        parent: {
          fileName: 'eui/src/components/description_list/description_list.tsx',
          name: 'EuiDescriptionListProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"normal" | "reverse"',
          value: [{
            value: '"normal"'
          }, {
            value: '"reverse"'
          }]
        }
      },
      type: {
        defaultValue: null,
        description: 'How each item should be layed out',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/description_list/description_list.tsx',
          name: 'EuiDescriptionListProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"inline" | "column" | "row" | "responsiveColumn"',
          value: [{
            value: '"inline"'
          }, {
            value: '"column"'
          }, {
            value: '"row"'
          }, {
            value: '"responsiveColumn"'
          }]
        }
      },
      titleProps: {
        defaultValue: null,
        description: 'Props object to be passed to `EuiDescriptionListTitle`',
        name: 'titleProps',
        parent: {
          fileName: 'eui/src/components/description_list/description_list.tsx',
          name: 'EuiDescriptionListProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLElement>'
        }
      },
      descriptionProps: {
        defaultValue: null,
        description: 'Props object to be passed to `EuiDescriptionListDescription`',
        name: 'descriptionProps',
        parent: {
          fileName: 'eui/src/components/description_list/description_list.tsx',
          name: 'EuiDescriptionListProps'
        },
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLElement>'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiDescriptionListTitle.__docgenInfo = {
    description: '',
    displayName: 'EuiDescriptionListTitle',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiDescriptionListDescription.__docgenInfo = {
    description: '',
    displayName: 'EuiDescriptionListDescription',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}