function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, cloneElement, useContext } from 'react';
import PropTypes from "prop-types";
import { Draggable } from 'react-beautiful-dnd';
import classNames from 'classnames';
import { EuiDroppableContext } from './droppable';
var spacingToClassNameMap = {
  none: null,
  s: 'euiDraggable--s',
  m: 'euiDraggable--m',
  l: 'euiDraggable--l'
};
export var EuiDraggable = function EuiDraggable(_ref) {
  var _ref$customDragHandle = _ref.customDragHandle,
      customDragHandle = _ref$customDragHandle === void 0 ? false : _ref$customDragHandle,
      draggableId = _ref.draggableId,
      _ref$isDragDisabled = _ref.isDragDisabled,
      isDragDisabled = _ref$isDragDisabled === void 0 ? false : _ref$isDragDisabled,
      _ref$isRemovable = _ref.isRemovable,
      isRemovable = _ref$isRemovable === void 0 ? false : _ref$isRemovable,
      index = _ref.index,
      children = _ref.children,
      className = _ref.className,
      _ref$spacing = _ref.spacing,
      spacing = _ref$spacing === void 0 ? 'none' : _ref$spacing,
      style = _ref.style,
      _ref$dataTestSubj = _ref['data-test-subj'],
      dataTestSubj = _ref$dataTestSubj === void 0 ? 'draggable' : _ref$dataTestSubj,
      rest = _objectWithoutProperties(_ref, ["customDragHandle", "draggableId", "isDragDisabled", "isRemovable", "index", "children", "className", "spacing", "style", "data-test-subj"]);

  var _useContext = useContext(EuiDroppableContext),
      cloneItems = _useContext.cloneItems;

  return React.createElement(Draggable, _extends({
    draggableId: draggableId,
    index: index,
    isDragDisabled: isDragDisabled
  }, rest), function (provided, snapshot, rubric) {
    var classes = classNames('euiDraggable', {
      'euiDraggable--hasClone': cloneItems,
      'euiDraggable--hasCustomDragHandle': customDragHandle,
      'euiDraggable--isDragging': snapshot.isDragging,
      'euiDraggable--withoutDropAnimation': isRemovable
    }, spacingToClassNameMap[spacing], className);
    var childClasses = classNames('euiDraggable__item', {
      'euiDraggable__item--hasCustomDragHandle': customDragHandle,
      'euiDraggable__item--isDisabled': isDragDisabled,
      'euiDraggable__item--isDragging': snapshot.isDragging,
      'euiDraggable__item--isDropAnimating': snapshot.isDropAnimating
    });
    var DraggableElement = typeof children === 'function' ? children(provided, snapshot, rubric) : children; // as specified by `DraggableProps`

    return React.createElement(Fragment, null, React.createElement("div", _extends({}, provided.draggableProps, !customDragHandle ? provided.dragHandleProps : {}, {
      ref: provided.innerRef,
      "data-test-subj": dataTestSubj,
      className: classes,
      style: _objectSpread({}, style, {}, provided.draggableProps.style)
    }), cloneElement(DraggableElement, {
      className: classNames(DraggableElement.props.className, childClasses)
    })), cloneItems && snapshot.isDragging && React.createElement("div", {
      className: classNames(classes, 'euiDraggable--clone')
    }, DraggableElement));
  });
};
EuiDraggable.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.any.isRequired]).isRequired,
  className: PropTypes.string,

  /**
     * Whether the `children` will provide and set up its own drag handle
     */
  customDragHandle: PropTypes.bool,

  /**
     * Whether the item is currently in a position to be removed
     */
  isRemovable: PropTypes.bool,

  /**
     * Adds padding to the draggable item
     */
  spacing: PropTypes.oneOf(["none", "s", "m", "l"]),
  style: PropTypes.any,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};

try {
  EuiDraggable.__docgenInfo = {
    description: '',
    displayName: 'EuiDraggable',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement | DraggableChildrenFn'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      customDragHandle: {
        defaultValue: {
          value: 'false'
        },
        description: 'Whether the `children` will provide and set up its own drag handle',
        name: 'customDragHandle',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isRemovable: {
        defaultValue: {
          value: 'false'
        },
        description: 'Whether the item is currently in a position to be removed',
        name: 'isRemovable',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      spacing: {
        defaultValue: {
          value: 'none'
        },
        description: 'Adds padding to the draggable item',
        name: 'spacing',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/draggable.tsx',
          name: 'EuiDraggableProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      index: {
        defaultValue: null,
        description: '',
        name: 'index',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      draggableId: {
        defaultValue: null,
        description: '',
        name: 'draggableId',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isDragDisabled: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'isDragDisabled',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disableInteractiveElementBlocking: {
        defaultValue: null,
        description: '',
        name: 'disableInteractiveElementBlocking',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      shouldRespectForcePress: {
        defaultValue: null,
        description: '',
        name: 'shouldRespectForcePress',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DraggableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: []
  };
} catch (e) {}