function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useContext } from 'react';
import PropTypes from "prop-types";
import { Droppable } from 'react-beautiful-dnd';
import classNames from 'classnames';
import { EuiDragDropContextContext } from './drag_drop_context';
var spacingToClassNameMap = {
  none: null,
  s: 'euiDroppable--s',
  m: 'euiDroppable--m',
  l: 'euiDroppable--l'
};
export var EuiDroppableContext = React.createContext({
  cloneItems: false
});
export var EuiDroppable = function EuiDroppable(_ref) {
  var droppableId = _ref.droppableId,
      direction = _ref.direction,
      _ref$isDropDisabled = _ref.isDropDisabled,
      isDropDisabled = _ref$isDropDisabled === void 0 ? false : _ref$isDropDisabled,
      children = _ref.children,
      className = _ref.className,
      _ref$cloneDraggables = _ref.cloneDraggables,
      cloneDraggables = _ref$cloneDraggables === void 0 ? false : _ref$cloneDraggables,
      _ref$spacing = _ref.spacing,
      spacing = _ref$spacing === void 0 ? 'none' : _ref$spacing,
      style = _ref.style,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'EUI_DEFAULT' : _ref$type,
      _ref$withPanel = _ref.withPanel,
      withPanel = _ref$withPanel === void 0 ? false : _ref$withPanel,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? false : _ref$grow,
      _ref$dataTestSubj = _ref['data-test-subj'],
      dataTestSubj = _ref$dataTestSubj === void 0 ? 'droppable' : _ref$dataTestSubj,
      rest = _objectWithoutProperties(_ref, ["droppableId", "direction", "isDropDisabled", "children", "className", "cloneDraggables", "spacing", "style", "type", "withPanel", "grow", "data-test-subj"]);

  var _useContext = useContext(EuiDragDropContextContext),
      isDraggingType = _useContext.isDraggingType;

  var dropIsDisabled = cloneDraggables ? true : isDropDisabled;
  return React.createElement(Droppable, _extends({
    isDropDisabled: dropIsDisabled,
    droppableId: droppableId,
    direction: direction,
    type: type
  }, rest), function (provided, snapshot) {
    var classes = classNames('euiDroppable', {
      'euiDroppable--isDisabled': dropIsDisabled,
      'euiDroppable--isDraggingOver': snapshot.isDraggingOver,
      'euiDroppable--isDraggingType': isDraggingType === type,
      'euiDroppable--withPanel': withPanel,
      'euiDroppable--grow': grow,
      'euiDroppable--noGrow': !grow
    }, spacingToClassNameMap[spacing], className);
    var placeholderClasses = classNames('euiDroppable__placeholder', {
      'euiDroppable__placeholder--isHidden': cloneDraggables
    });
    var DroppableElement = typeof children === 'function' ? children(provided, snapshot) : children;
    return React.createElement("div", _extends({}, provided.droppableProps, {
      ref: provided.innerRef,
      style: style,
      "data-test-subj": dataTestSubj,
      className: classes
    }), React.createElement(EuiDroppableContext.Provider, {
      value: {
        cloneItems: cloneDraggables
      }
    }, DroppableElement), React.createElement("div", {
      className: placeholderClasses
    }, provided.placeholder));
  });
};
EuiDroppable.propTypes = {
  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.oneOfType([PropTypes.element.isRequired, PropTypes.arrayOf(PropTypes.element.isRequired).isRequired, PropTypes.any.isRequired]).isRequired,
  className: PropTypes.string,

  /**
     * Makes its items immutable. Dragging creates cloned items that can be dropped elsewhere.
     */
  cloneDraggables: PropTypes.bool,
  style: PropTypes.any,

  /**
     * Adds padding to the droppable area
     */
  spacing: PropTypes.oneOf(["none", "s", "m", "l"]),

  /**
     * Adds an EuiPanel style to the droppable area
     */
  withPanel: PropTypes.bool,

  /**
     * Allow the panel to flex-grow?
     */
  grow: PropTypes.bool,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};

try {
  EuiDroppable.__docgenInfo = {
    description: '',
    displayName: 'EuiDroppable',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement | ReactElement<...>[] | ((provided: DroppableProvided, snapshot: DroppableStateSnapshot) => ReactElement<...>)'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      cloneDraggables: {
        defaultValue: {
          value: 'false'
        },
        description: 'Makes its items immutable. Dragging creates cloned items that can be dropped elsewhere.',
        name: 'cloneDraggables',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      spacing: {
        defaultValue: {
          value: 'none'
        },
        description: 'Adds padding to the droppable area',
        name: 'spacing',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'BottomBarPaddingSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }]
        }
      },
      withPanel: {
        defaultValue: {
          value: 'false'
        },
        description: 'Adds an EuiPanel style to the droppable area',
        name: 'withPanel',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      grow: {
        defaultValue: {
          value: 'false'
        },
        description: 'Allow the panel to flex-grow?',
        name: 'grow',
        parent: {
          fileName: 'eui/src/components/drag_and_drop/droppable.tsx',
          name: 'EuiDroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: {
          value: 'EUI_DEFAULT'
        },
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      direction: {
        defaultValue: null,
        description: '',
        name: 'direction',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"horizontal" | "vertical"',
          value: [{
            value: '"horizontal"'
          }, {
            value: '"vertical"'
          }]
        }
      },
      mode: {
        defaultValue: null,
        description: '',
        name: 'mode',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'DroppableMode',
          value: [{
            value: '"standard"'
          }, {
            value: '"virtual"'
          }]
        }
      },
      droppableId: {
        defaultValue: null,
        description: '',
        name: 'droppableId',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isDropDisabled: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'isDropDisabled',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isCombineEnabled: {
        defaultValue: null,
        description: '',
        name: 'isCombineEnabled',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ignoreContainerClipping: {
        defaultValue: null,
        description: '',
        name: 'ignoreContainerClipping',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      renderClone: {
        defaultValue: null,
        description: '',
        name: 'renderClone',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: 'DraggableChildrenFn'
        }
      },
      getContainerForClone: {
        defaultValue: null,
        description: '',
        name: 'getContainerForClone',
        parent: {
          fileName: 'eui/node_modules/@types/react-beautiful-dnd/index.d.ts',
          name: 'DroppableProps'
        },
        required: false,
        type: {
          name: '() => ReactElement<HTMLElement, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)>'
        }
      }
    },
    extends: []
  };
} catch (e) {}