function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { keysOf } from '../common';
var directionToClassNameMap = {
  row: null,
  column: 'euiFlexGrid--directionColumn'
};
export var DIRECTIONS = keysOf(directionToClassNameMap);
var gutterSizeToClassNameMap = {
  none: 'euiFlexGrid--gutterNone',
  s: 'euiFlexGrid--gutterSmall',
  m: 'euiFlexGrid--gutterMedium',
  l: 'euiFlexGrid--gutterLarge',
  xl: 'euiFlexGrid--gutterXLarge'
};
export var GUTTER_SIZES = keysOf(gutterSizeToClassNameMap);
var columnsToClassNameMap = {
  0: 'euiFlexGrid--wrap',
  1: 'euiFlexGrid--single',
  2: 'euiFlexGrid--halves',
  3: 'euiFlexGrid--thirds',
  4: 'euiFlexGrid--fourths'
};
export var COLUMNS = Object.keys(columnsToClassNameMap).map(function (columns) {
  return parseInt(columns, 10);
});
export var EuiFlexGrid = function EuiFlexGrid(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$gutterSize = _ref.gutterSize,
      gutterSize = _ref$gutterSize === void 0 ? 'l' : _ref$gutterSize,
      _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? 'row' : _ref$direction,
      _ref$responsive = _ref.responsive,
      responsive = _ref$responsive === void 0 ? true : _ref$responsive,
      _ref$columns = _ref.columns,
      columns = _ref$columns === void 0 ? 0 : _ref$columns,
      _ref$component = _ref.component,
      Component = _ref$component === void 0 ? 'div' : _ref$component,
      rest = _objectWithoutProperties(_ref, ["children", "className", "gutterSize", "direction", "responsive", "columns", "component"]);

  var classes = classNames('euiFlexGrid', gutterSize ? gutterSizeToClassNameMap[gutterSize] : undefined, columns != null ? columnsToClassNameMap[columns] : undefined, direction ? directionToClassNameMap[direction] : undefined, {
    'euiFlexGrid--responsive': responsive
  }, className);
  return (// @ts-ignore difficult to verify `rest` applies to `Component`
    React.createElement(Component, _extends({
      className: classes
    }, rest), children)
  );
};
EuiFlexGrid.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
     * ReactNode to render as this component's content
     */
  children: PropTypes.node,

  /**
     * Number of columns `1-4`, pass `0` for normal display
     */
  columns: PropTypes.oneOf([0, 1, 2, 3, 4]),

  /**
     * Flex layouts default to left-right then top-down (`row`).
     * Change this prop to `column` to create a top-down then left-right display.
     * Only works with column count of `1-4`.
     */
  direction: PropTypes.oneOf(["row", "column"]),

  /**
     * Space between flex items
     */
  gutterSize: PropTypes.oneOf(["none", "s", "m", "l", "xl"]),

  /**
     * Force each item to be display block on smaller screens
     */
  responsive: PropTypes.bool,

  /**
     * The tag to render
     */
  component: PropTypes.any
};

try {
  EuiFlexGrid.__docgenInfo = {
    description: '',
    displayName: 'EuiFlexGrid',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      columns: {
        defaultValue: {
          value: '0'
        },
        description: 'Number of columns `1-4`, pass `0` for normal display',
        name: 'columns',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'FlexGridColumns'
        }
      },
      direction: {
        defaultValue: {
          value: 'row'
        },
        description: 'Flex layouts default to left-right then top-down (`row`).\nChange this prop to `column` to create a top-down then left-right display.\nOnly works with column count of `1-4`.',
        name: 'direction',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"column" | "row"',
          value: [{
            value: '"column"'
          }, {
            value: '"row"'
          }]
        }
      },
      gutterSize: {
        defaultValue: {
          value: 'l'
        },
        description: 'Space between flex items',
        name: 'gutterSize',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "none" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      responsive: {
        defaultValue: {
          value: 'true'
        },
        description: 'Force each item to be display block on smaller screens',
        name: 'responsive',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      component: {
        defaultValue: null,
        description: 'The tag to render',
        name: 'component',
        parent: {
          fileName: 'eui/src/components/flex/flex_grid.tsx',
          name: 'EuiFlexGridProps'
        },
        required: false,
        type: {
          name: 'any HTML Element',
          raw: '"symbol" | "object" | "slot" | "style" | "title" | "form" | "text" | "s" | "filter" | "image" | "link" | "menu" | "stop" | "button" | "time" | "dialog" | "clipPath" | "mask" | "path" | ... 155 more ... | "view"',
          value: [{
            value: '"symbol"'
          }, {
            value: '"object"'
          }, {
            value: '"slot"'
          }, {
            value: '"style"'
          }, {
            value: '"title"'
          }, {
            value: '"form"'
          }, {
            value: '"text"'
          }, {
            value: '"s"'
          }, {
            value: '"filter"'
          }, {
            value: '"image"'
          }, {
            value: '"link"'
          }, {
            value: '"menu"'
          }, {
            value: '"stop"'
          }, {
            value: '"button"'
          }, {
            value: '"time"'
          }, {
            value: '"dialog"'
          }, {
            value: '"clipPath"'
          }, {
            value: '"mask"'
          }, {
            value: '"path"'
          }, {
            value: '"label"'
          }, {
            value: '"summary"'
          }, {
            value: '"legend"'
          }, {
            value: '"h1"'
          }, {
            value: '"h2"'
          }, {
            value: '"h3"'
          }, {
            value: '"h4"'
          }, {
            value: '"h5"'
          }, {
            value: '"h6"'
          }, {
            value: '"p"'
          }, {
            value: '"footer"'
          }, {
            value: '"span"'
          }, {
            value: '"pattern"'
          }, {
            value: '"pre"'
          }, {
            value: '"a"'
          }, {
            value: '"abbr"'
          }, {
            value: '"address"'
          }, {
            value: '"area"'
          }, {
            value: '"article"'
          }, {
            value: '"aside"'
          }, {
            value: '"audio"'
          }, {
            value: '"b"'
          }, {
            value: '"base"'
          }, {
            value: '"bdi"'
          }, {
            value: '"bdo"'
          }, {
            value: '"big"'
          }, {
            value: '"blockquote"'
          }, {
            value: '"body"'
          }, {
            value: '"br"'
          }, {
            value: '"canvas"'
          }, {
            value: '"caption"'
          }, {
            value: '"cite"'
          }, {
            value: '"code"'
          }, {
            value: '"col"'
          }, {
            value: '"colgroup"'
          }, {
            value: '"data"'
          }, {
            value: '"datalist"'
          }, {
            value: '"dd"'
          }, {
            value: '"del"'
          }, {
            value: '"details"'
          }, {
            value: '"dfn"'
          }, {
            value: '"div"'
          }, {
            value: '"dl"'
          }, {
            value: '"dt"'
          }, {
            value: '"em"'
          }, {
            value: '"embed"'
          }, {
            value: '"fieldset"'
          }, {
            value: '"figcaption"'
          }, {
            value: '"figure"'
          }, {
            value: '"head"'
          }, {
            value: '"header"'
          }, {
            value: '"hgroup"'
          }, {
            value: '"hr"'
          }, {
            value: '"html"'
          }, {
            value: '"i"'
          }, {
            value: '"iframe"'
          }, {
            value: '"img"'
          }, {
            value: '"input"'
          }, {
            value: '"ins"'
          }, {
            value: '"kbd"'
          }, {
            value: '"keygen"'
          }, {
            value: '"li"'
          }, {
            value: '"main"'
          }, {
            value: '"map"'
          }, {
            value: '"mark"'
          }, {
            value: '"menuitem"'
          }, {
            value: '"meta"'
          }, {
            value: '"meter"'
          }, {
            value: '"nav"'
          }, {
            value: '"noindex"'
          }, {
            value: '"noscript"'
          }, {
            value: '"ol"'
          }, {
            value: '"optgroup"'
          }, {
            value: '"option"'
          }, {
            value: '"output"'
          }, {
            value: '"param"'
          }, {
            value: '"picture"'
          }, {
            value: '"progress"'
          }, {
            value: '"q"'
          }, {
            value: '"rp"'
          }, {
            value: '"rt"'
          }, {
            value: '"ruby"'
          }, {
            value: '"samp"'
          }, {
            value: '"script"'
          }, {
            value: '"section"'
          }, {
            value: '"select"'
          }, {
            value: '"small"'
          }, {
            value: '"source"'
          }, {
            value: '"strong"'
          }, {
            value: '"sub"'
          }, {
            value: '"sup"'
          }, {
            value: '"table"'
          }, {
            value: '"template"'
          }, {
            value: '"tbody"'
          }, {
            value: '"td"'
          }, {
            value: '"textarea"'
          }, {
            value: '"tfoot"'
          }, {
            value: '"th"'
          }, {
            value: '"thead"'
          }, {
            value: '"tr"'
          }, {
            value: '"track"'
          }, {
            value: '"u"'
          }, {
            value: '"ul"'
          }, {
            value: '"var"'
          }, {
            value: '"video"'
          }, {
            value: '"wbr"'
          }, {
            value: '"webview"'
          }, {
            value: '"svg"'
          }, {
            value: '"animate"'
          }, {
            value: '"animateMotion"'
          }, {
            value: '"animateTransform"'
          }, {
            value: '"circle"'
          }, {
            value: '"defs"'
          }, {
            value: '"desc"'
          }, {
            value: '"ellipse"'
          }, {
            value: '"feBlend"'
          }, {
            value: '"feColorMatrix"'
          }, {
            value: '"feComponentTransfer"'
          }, {
            value: '"feComposite"'
          }, {
            value: '"feConvolveMatrix"'
          }, {
            value: '"feDiffuseLighting"'
          }, {
            value: '"feDisplacementMap"'
          }, {
            value: '"feDistantLight"'
          }, {
            value: '"feDropShadow"'
          }, {
            value: '"feFlood"'
          }, {
            value: '"feFuncA"'
          }, {
            value: '"feFuncB"'
          }, {
            value: '"feFuncG"'
          }, {
            value: '"feFuncR"'
          }, {
            value: '"feGaussianBlur"'
          }, {
            value: '"feImage"'
          }, {
            value: '"feMerge"'
          }, {
            value: '"feMergeNode"'
          }, {
            value: '"feMorphology"'
          }, {
            value: '"feOffset"'
          }, {
            value: '"fePointLight"'
          }, {
            value: '"feSpecularLighting"'
          }, {
            value: '"feSpotLight"'
          }, {
            value: '"feTile"'
          }, {
            value: '"feTurbulence"'
          }, {
            value: '"foreignObject"'
          }, {
            value: '"g"'
          }, {
            value: '"line"'
          }, {
            value: '"linearGradient"'
          }, {
            value: '"marker"'
          }, {
            value: '"metadata"'
          }, {
            value: '"mpath"'
          }, {
            value: '"polygon"'
          }, {
            value: '"polyline"'
          }, {
            value: '"radialGradient"'
          }, {
            value: '"rect"'
          }, {
            value: '"switch"'
          }, {
            value: '"textPath"'
          }, {
            value: '"tspan"'
          }, {
            value: '"use"'
          }, {
            value: '"view"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}