function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
export var GROW_SIZES = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
export var EuiFlexItem = function EuiFlexItem(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      _ref$component = _ref.component,
      Component = _ref$component === void 0 ? 'div' : _ref$component,
      rest = _objectWithoutProperties(_ref, ["children", "className", "grow", "component"]);

  validateGrowValue(grow);
  var classes = classNames('euiFlexItem', _defineProperty({
    'euiFlexItem--flexGrowZero': !grow
  }, "euiFlexItem--flexGrow".concat(grow), typeof grow === 'number' ? GROW_SIZES.indexOf(grow) >= 0 : undefined), className);
  return (// @ts-ignore difficult to verify `rest` applies to `Component`
    React.createElement(Component, _extends({
      className: classes
    }, rest), children)
  );
};
EuiFlexItem.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  grow: PropTypes.oneOf([1, 2, 3, 4, 5, 6, 7, 8, 9, 10, true, false, null]),
  component: PropTypes.any
};

function validateGrowValue(value) {
  var validValues = [null, undefined, true, false].concat(GROW_SIZES);

  if (validValues.indexOf(value) === -1) {
    throw new Error("Prop `grow` passed to `EuiFlexItem` must be a boolean or an integer between 1 and 10, received `".concat(value, "`"));
  }
}

try {
  EuiFlexItem.__docgenInfo = {
    description: '',
    displayName: 'EuiFlexItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      grow: {
        defaultValue: {
          value: 'true'
        },
        description: '',
        name: 'grow',
        parent: {
          fileName: 'eui/src/components/flex/flex_item.tsx',
          name: 'EuiFlexItemProps'
        },
        required: false,
        type: {
          name: 'FlexItemGrowSize'
        }
      },
      component: {
        defaultValue: null,
        description: '',
        name: 'component',
        parent: {
          fileName: 'eui/src/components/flex/flex_item.tsx',
          name: 'EuiFlexItemProps'
        },
        required: false,
        type: {
          name: 'any HTML Element',
          raw: '"symbol" | "object" | "slot" | "style" | "title" | "form" | "text" | "s" | "filter" | "image" | "link" | "menu" | "stop" | "button" | "time" | "dialog" | "clipPath" | "mask" | "path" | ... 155 more ... | "view"',
          value: [{
            value: '"symbol"'
          }, {
            value: '"object"'
          }, {
            value: '"slot"'
          }, {
            value: '"style"'
          }, {
            value: '"title"'
          }, {
            value: '"form"'
          }, {
            value: '"text"'
          }, {
            value: '"s"'
          }, {
            value: '"filter"'
          }, {
            value: '"image"'
          }, {
            value: '"link"'
          }, {
            value: '"menu"'
          }, {
            value: '"stop"'
          }, {
            value: '"button"'
          }, {
            value: '"time"'
          }, {
            value: '"dialog"'
          }, {
            value: '"clipPath"'
          }, {
            value: '"mask"'
          }, {
            value: '"path"'
          }, {
            value: '"label"'
          }, {
            value: '"summary"'
          }, {
            value: '"legend"'
          }, {
            value: '"h1"'
          }, {
            value: '"h2"'
          }, {
            value: '"h3"'
          }, {
            value: '"h4"'
          }, {
            value: '"h5"'
          }, {
            value: '"h6"'
          }, {
            value: '"p"'
          }, {
            value: '"footer"'
          }, {
            value: '"span"'
          }, {
            value: '"pattern"'
          }, {
            value: '"pre"'
          }, {
            value: '"a"'
          }, {
            value: '"abbr"'
          }, {
            value: '"address"'
          }, {
            value: '"area"'
          }, {
            value: '"article"'
          }, {
            value: '"aside"'
          }, {
            value: '"audio"'
          }, {
            value: '"b"'
          }, {
            value: '"base"'
          }, {
            value: '"bdi"'
          }, {
            value: '"bdo"'
          }, {
            value: '"big"'
          }, {
            value: '"blockquote"'
          }, {
            value: '"body"'
          }, {
            value: '"br"'
          }, {
            value: '"canvas"'
          }, {
            value: '"caption"'
          }, {
            value: '"cite"'
          }, {
            value: '"code"'
          }, {
            value: '"col"'
          }, {
            value: '"colgroup"'
          }, {
            value: '"data"'
          }, {
            value: '"datalist"'
          }, {
            value: '"dd"'
          }, {
            value: '"del"'
          }, {
            value: '"details"'
          }, {
            value: '"dfn"'
          }, {
            value: '"div"'
          }, {
            value: '"dl"'
          }, {
            value: '"dt"'
          }, {
            value: '"em"'
          }, {
            value: '"embed"'
          }, {
            value: '"fieldset"'
          }, {
            value: '"figcaption"'
          }, {
            value: '"figure"'
          }, {
            value: '"head"'
          }, {
            value: '"header"'
          }, {
            value: '"hgroup"'
          }, {
            value: '"hr"'
          }, {
            value: '"html"'
          }, {
            value: '"i"'
          }, {
            value: '"iframe"'
          }, {
            value: '"img"'
          }, {
            value: '"input"'
          }, {
            value: '"ins"'
          }, {
            value: '"kbd"'
          }, {
            value: '"keygen"'
          }, {
            value: '"li"'
          }, {
            value: '"main"'
          }, {
            value: '"map"'
          }, {
            value: '"mark"'
          }, {
            value: '"menuitem"'
          }, {
            value: '"meta"'
          }, {
            value: '"meter"'
          }, {
            value: '"nav"'
          }, {
            value: '"noindex"'
          }, {
            value: '"noscript"'
          }, {
            value: '"ol"'
          }, {
            value: '"optgroup"'
          }, {
            value: '"option"'
          }, {
            value: '"output"'
          }, {
            value: '"param"'
          }, {
            value: '"picture"'
          }, {
            value: '"progress"'
          }, {
            value: '"q"'
          }, {
            value: '"rp"'
          }, {
            value: '"rt"'
          }, {
            value: '"ruby"'
          }, {
            value: '"samp"'
          }, {
            value: '"script"'
          }, {
            value: '"section"'
          }, {
            value: '"select"'
          }, {
            value: '"small"'
          }, {
            value: '"source"'
          }, {
            value: '"strong"'
          }, {
            value: '"sub"'
          }, {
            value: '"sup"'
          }, {
            value: '"table"'
          }, {
            value: '"template"'
          }, {
            value: '"tbody"'
          }, {
            value: '"td"'
          }, {
            value: '"textarea"'
          }, {
            value: '"tfoot"'
          }, {
            value: '"th"'
          }, {
            value: '"thead"'
          }, {
            value: '"tr"'
          }, {
            value: '"track"'
          }, {
            value: '"u"'
          }, {
            value: '"ul"'
          }, {
            value: '"var"'
          }, {
            value: '"video"'
          }, {
            value: '"wbr"'
          }, {
            value: '"webview"'
          }, {
            value: '"svg"'
          }, {
            value: '"animate"'
          }, {
            value: '"animateMotion"'
          }, {
            value: '"animateTransform"'
          }, {
            value: '"circle"'
          }, {
            value: '"defs"'
          }, {
            value: '"desc"'
          }, {
            value: '"ellipse"'
          }, {
            value: '"feBlend"'
          }, {
            value: '"feColorMatrix"'
          }, {
            value: '"feComponentTransfer"'
          }, {
            value: '"feComposite"'
          }, {
            value: '"feConvolveMatrix"'
          }, {
            value: '"feDiffuseLighting"'
          }, {
            value: '"feDisplacementMap"'
          }, {
            value: '"feDistantLight"'
          }, {
            value: '"feDropShadow"'
          }, {
            value: '"feFlood"'
          }, {
            value: '"feFuncA"'
          }, {
            value: '"feFuncB"'
          }, {
            value: '"feFuncG"'
          }, {
            value: '"feFuncR"'
          }, {
            value: '"feGaussianBlur"'
          }, {
            value: '"feImage"'
          }, {
            value: '"feMerge"'
          }, {
            value: '"feMergeNode"'
          }, {
            value: '"feMorphology"'
          }, {
            value: '"feOffset"'
          }, {
            value: '"fePointLight"'
          }, {
            value: '"feSpecularLighting"'
          }, {
            value: '"feSpotLight"'
          }, {
            value: '"feTile"'
          }, {
            value: '"feTurbulence"'
          }, {
            value: '"foreignObject"'
          }, {
            value: '"g"'
          }, {
            value: '"line"'
          }, {
            value: '"linearGradient"'
          }, {
            value: '"marker"'
          }, {
            value: '"metadata"'
          }, {
            value: '"mpath"'
          }, {
            value: '"polygon"'
          }, {
            value: '"polyline"'
          }, {
            value: '"radialGradient"'
          }, {
            value: '"rect"'
          }, {
            value: '"switch"'
          }, {
            value: '"textPath"'
          }, {
            value: '"tspan"'
          }, {
            value: '"use"'
          }, {
            value: '"view"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}