/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiFlyout } from './flyout';
export { EuiFlyoutBody } from './flyout_body';
export { EuiFlyoutFooter } from './flyout_footer';
export { EuiFlyoutHeader } from './flyout_header';

try {
  EuiFlyout.__docgenInfo = {
    description: '',
    displayName: 'EuiFlyout',
    methods: [],
    props: {
      onClose: {
        defaultValue: null,
        description: '',
        name: 'onClose',
        parent: {
          fileName: 'eui/src/components/flyout/flyout.tsx',
          name: 'EuiFlyoutProps'
        },
        required: true,
        type: {
          name: '() => void'
        }
      },
      size: {
        defaultValue: null,
        description: 'Defines the width of the panel',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/flyout/flyout.tsx',
          name: 'EuiFlyoutProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }]
        }
      },
      hideCloseButton: {
        defaultValue: null,
        description: 'Hides the default close button. You must provide another close button somewhere within the flyout.',
        name: 'hideCloseButton',
        parent: {
          fileName: 'eui/src/components/flyout/flyout.tsx',
          name: 'EuiFlyoutProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ownFocus: {
        defaultValue: null,
        description: 'Locks the mouse / keyboard focus to within the flyout,\nand shows an EuiOverlayMask',
        name: 'ownFocus',
        parent: {
          fileName: 'eui/src/components/flyout/flyout.tsx',
          name: 'EuiFlyoutProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      closeButtonAriaLabel: {
        defaultValue: null,
        description: 'Specify an aria-label for the close button of the flyout.\nDefault is `\'Close this dialog\'`.',
        name: 'closeButtonAriaLabel',
        parent: {
          fileName: 'eui/src/components/flyout/flyout.tsx',
          name: 'EuiFlyoutProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      maxWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the panel,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'maxWidth',
        parent: {
          fileName: 'eui/src/components/flyout/flyout.tsx',
          name: 'EuiFlyoutProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/flyout/flyout.tsx',
          name: 'EuiFlyoutProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      maskProps: {
        defaultValue: null,
        description: 'Adjustments to the EuiOverlayMask that is added when `ownFocus = true`',
        name: 'maskProps',
        parent: {
          fileName: 'eui/src/components/flyout/flyout.tsx',
          name: 'EuiFlyoutProps'
        },
        required: false,
        type: {
          name: 'EuiOverlayMaskProps'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiFlyoutBody.__docgenInfo = {
    description: '',
    displayName: 'EuiFlyoutBody',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      banner: {
        defaultValue: null,
        description: 'Use to display a banner at the top of the body. It is suggested to use `EuiCallOut` for it.',
        name: 'banner',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiFlyoutFooter.__docgenInfo = {
    description: '',
    displayName: 'EuiFlyoutFooter',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiFlyoutHeader.__docgenInfo = {
    description: '',
    displayName: 'EuiFlyoutHeader',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      hasBorder: {
        defaultValue: null,
        description: '',
        name: 'hasBorder',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}