function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { cloneElement } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiText } from '../../text';
import { EuiFormControlLayout } from './form_control_layout';
export var EuiFormControlLayoutDelimited = function EuiFormControlLayoutDelimited(_ref) {
  var startControl = _ref.startControl,
      endControl = _ref.endControl,
      _ref$delimiter = _ref.delimiter,
      delimiter = _ref$delimiter === void 0 ? '→' : _ref$delimiter,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["startControl", "endControl", "delimiter", "className"]);

  var classes = classNames('euiFormControlLayoutDelimited', className);
  return React.createElement(EuiFormControlLayout, _extends({
    className: classes
  }, rest), addClassesToControl(startControl), React.createElement(EuiText, {
    className: "euiFormControlLayoutDelimited__delimeter",
    size: "s",
    color: "subdued"
  }, delimiter), addClassesToControl(endControl));
};
EuiFormControlLayoutDelimited.propTypes = {
  /**
     * Left side control
     */
  startControl: PropTypes.element.isRequired,

  /**
     * Right side control
     */
  endControl: PropTypes.element.isRequired,

  /**
     * The center content. Accepts a string to be wrapped in a subdued EuiText
     * or a single ReactElement
     */
  delimiter: PropTypes.node,
  className: PropTypes.string
};

function addClassesToControl(control) {
  return cloneElement(control, {
    className: classNames(control.props.className, 'euiFormControlLayoutDelimited__input')
  });
}

try {
  EuiFormControlLayoutDelimited.__docgenInfo = {
    description: '',
    displayName: 'EuiFormControlLayoutDelimited',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before children.\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after children.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ComponentClass<{}, any> | FunctionComponent<{}> | (Pick<CommonProps & DisambiguateSet<Pick<ButtonHTMLAttributes<HTMLButtonElement>, "children" | ... 262 more ... | "value">, HTMLAttributes<...>> & HTMLAttributes<...> & { ...; }, "children" | ... 263 more ... | "value"> & { ...; }) | (Pick<...> & { ...; })'
        }
      },
      clear: {
        defaultValue: null,
        description: '',
        name: 'clear',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiFormControlLayoutClearButtonProps'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      readOnly: {
        defaultValue: null,
        description: '',
        name: 'readOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      inputId: {
        defaultValue: null,
        description: 'Connects the prepend and append labels to the input',
        name: 'inputId',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      startControl: {
        defaultValue: null,
        description: 'Left side control',
        name: 'startControl',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      endControl: {
        defaultValue: null,
        description: 'Right side control',
        name: 'endControl',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      delimiter: {
        defaultValue: {
          value: '→'
        },
        description: 'The center content. Accepts a string to be wrapped in a subdued EuiText\nor a single ReactElement',
        name: 'delimiter',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}