function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiScreenReaderOnly } from '../../accessibility';
export var EuiFormLegend = function EuiFormLegend(_ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$display = _ref.display,
      display = _ref$display === void 0 ? 'visible' : _ref$display,
      compressed = _ref.compressed,
      rest = _objectWithoutProperties(_ref, ["children", "className", "display", "compressed"]);

  var isLegendHidden = display === 'hidden';
  var classes = classNames('euiFormLegend', {
    'euiFormLegend-isHidden': isLegendHidden,
    'euiFormLegend--compressed': compressed
  }, className);
  return React.createElement("legend", _extends({
    className: classes
  }, rest), isLegendHidden ? React.createElement(EuiScreenReaderOnly, null, React.createElement("span", null, children)) : children);
};
EuiFormLegend.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
       * ReactNode to render as this component's content
       */
  children: PropTypes.node.isRequired,

  /**
       * For a hidden legend that is still visible to the screen reader, set to 'hidden'
       */
  display: PropTypes.oneOf(["hidden", "visible"]),
  compressed: PropTypes.bool
};

try {
  EuiFormLegend.__docgenInfo = {
    description: '',
    displayName: 'EuiFormLegend',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      display: {
        defaultValue: {
          value: 'visible'
        },
        description: 'For a hidden legend that is still visible to the screen reader, set to \'hidden\'',
        name: 'display',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"hidden" | "visible"',
          value: [{
            value: '"hidden"'
          }, {
            value: '"visible"'
          }]
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}