/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiFormRow } from './form_row';

try {
  EuiFormRow.__docgenInfo = {
    description: '',
    displayName: 'EuiFormRow',
    methods: [],
    props: {
      labelType: {
        defaultValue: null,
        description: 'Defaults to rendering a `<label>` but if passed `\'legend\'` for labelType,\nwill render both a `<legend>` and the surrounding container as a `<fieldset>`',
        name: 'labelType',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"label" | "legend"',
          value: [{
            value: '"label"'
          }, {
            value: '"legend"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      display: {
        defaultValue: null,
        description: 'When `rowCompressed`, just tightens up the spacing;\nSet to `columnCompressed` if compressed\nand horizontal layout is needed.\nSet to `center` or `centerCompressed` to align non-input\ncontent better with inline rows.\nSet to `columnCompressedSwitch` if the form control being passed\nas the child is a switch.',
        name: 'display',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"center" | "row" | "rowCompressed" | "columnCompressed" | "centerCompressed" | "columnCompressedSwitch"',
          value: [{
            value: '"center"'
          }, {
            value: '"row"'
          }, {
            value: '"rowCompressed"'
          }, {
            value: '"columnCompressed"'
          }, {
            value: '"centerCompressed"'
          }, {
            value: '"columnCompressedSwitch"'
          }]
        }
      },
      hasEmptyLabelSpace: {
        defaultValue: null,
        description: '',
        name: 'hasEmptyLabelSpace',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      describedByIds: {
        defaultValue: null,
        description: 'IDs of additional elements that should be part of children\'s `aria-describedby`',
        name: 'describedByIds',
        parent: undefined,
        required: false,
        type: {
          name: 'string[]'
        }
      },
      hasChildLabel: {
        defaultValue: null,
        description: 'Escape hatch to not render duplicate labels if the child also renders a label',
        name: 'hasChildLabel',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactElement to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      labelAppend: {
        defaultValue: null,
        description: 'Adds an extra node to the right of the form label without\nbeing contained inside the form label. Good for things\nlike documentation links.',
        name: 'labelAppend',
        parent: undefined,
        required: false,
        type: {
          name: 'any'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      error: {
        defaultValue: null,
        description: '',
        name: 'error',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number | boolean | {} | ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)> | ReactNodeArray | ReactPortal | ReactNode[]'
        }
      },
      helpText: {
        defaultValue: null,
        description: '',
        name: 'helpText',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      compressed: {
        defaultValue: null,
        description: '**DEPRECATED: use `display: rowCompressed` instead.**\nWhen `true`, tightens up the spacing.',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      displayOnly: {
        defaultValue: null,
        description: '**DEPRECATED: use `display: center` instead.**\nVertically centers non-input style content so it aligns\nbetter with input style content.',
        name: 'displayOnly',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}