/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiRadio } from './radio';
export { EuiRadioGroup } from './radio_group';

try {
  EuiRadio.__docgenInfo = {
    description: '',
    displayName: 'EuiRadio',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'idWithLabel'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'withId'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      autoFocus: {
        defaultValue: null,
        description: '',
        name: 'autoFocus',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'RadioProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: null,
        description: 'When `true` creates a shorter height radio row',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'RadioProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'RadioProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'RadioProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      checked: {
        defaultValue: null,
        description: '',
        name: 'checked',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'RadioProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'RadioProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: {
          fileName: 'eui/src/components/form/radio/radio.tsx',
          name: 'RadioProps'
        },
        required: true,
        type: {
          name: '(event: ChangeEvent<HTMLInputElement>) => void'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiRadioGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiRadioGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: null,
        description: 'Tightens up the spacing between radio rows and sends down the\ncompressed prop to the radio itself',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiRadioGroupOption[]'
        }
      },
      idSelected: {
        defaultValue: null,
        description: '',
        name: 'idSelected',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiRadioGroupChangeCallback'
        }
      },
      legend: {
        defaultValue: null,
        description: 'Adds an EuiFormLegend element as the first child\nIf the individual labels for each radio do not provide a sufficient description, add a legend.\nWraps the group in a `EuiFormFieldset` which adds an `EuiLegend` for titling the whole group.\nAccepts an `EuiFormLegendProps` shape.',
        name: 'legend',
        parent: {
          fileName: 'eui/src/components/form/form_fieldset/form_fieldset.tsx',
          name: 'EuiFormFieldsetProps'
        },
        required: false,
        type: {
          name: 'EuiFormLegendProps'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}