/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
export var EuiRangeHighlight = function EuiRangeHighlight(_ref) {
  var className = _ref.className,
      hasFocus = _ref.hasFocus,
      showTicks = _ref.showTicks,
      lowerValue = _ref.lowerValue,
      upperValue = _ref.upperValue,
      max = _ref.max,
      min = _ref.min,
      compressed = _ref.compressed,
      background = _ref.background,
      onClick = _ref.onClick;
  // Calculate the width the range based on value
  // const rangeWidth = (value - min) / (max - min);
  var leftPosition = (lowerValue - min) / (max - min);
  var rangeWidth = (upperValue - lowerValue) / (max - min);
  var rangeWidthStyle = {
    background: background,
    marginLeft: "".concat(leftPosition * 100, "%"),
    width: "".concat(rangeWidth * 100, "%")
  };
  var classes = classNames('euiRangeHighlight', {
    'euiRangeHighlight--hasTicks': showTicks,
    'euiRangeHighlight--compressed': compressed
  }, className);
  var progressClasses = classNames('euiRangeHighlight__progress', {
    'euiRangeHighlight__progress--hasFocus': hasFocus
  });
  return React.createElement("div", {
    className: classes,
    onClick: onClick
  }, React.createElement("div", {
    className: progressClasses,
    style: rangeWidthStyle
  }));
};
EuiRangeHighlight.propTypes = {
  className: PropTypes.string,
  background: PropTypes.string,
  compressed: PropTypes.bool,
  hasFocus: PropTypes.bool,
  showTicks: PropTypes.bool,
  lowerValue: PropTypes.number.isRequired,
  upperValue: PropTypes.number.isRequired,
  max: PropTypes.number.isRequired,
  min: PropTypes.number.isRequired,
  onClick: PropTypes.func
};

try {
  EuiRangeHighlight.__docgenInfo = {
    description: '',
    displayName: 'EuiRangeHighlight',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      background: {
        defaultValue: null,
        description: '',
        name: 'background',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hasFocus: {
        defaultValue: null,
        description: '',
        name: 'hasFocus',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showTicks: {
        defaultValue: null,
        description: '',
        name: 'showTicks',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      lowerValue: {
        defaultValue: null,
        description: '',
        name: 'lowerValue',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      upperValue: {
        defaultValue: null,
        description: '',
        name: 'upperValue',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      max: {
        defaultValue: null,
        description: '',
        name: 'max',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      min: {
        defaultValue: null,
        description: '',
        name: 'min',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/form/range/range_highlight.tsx',
          name: 'EuiRangeHighlightProps'
        },
        required: false,
        type: {
          name: '(e: any) => void'
        }
      }
    },
    extends: []
  };
} catch (e) {}