/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiSwitch } from './switch';

try {
  EuiSwitch.__docgenInfo = {
    description: '',
    displayName: 'EuiSwitch',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      showLabel: {
        defaultValue: null,
        description: 'Whether to render the render the text label',
        name: 'showLabel',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      label: {
        defaultValue: null,
        description: 'Must be a string if `showLabel` prop is false',
        name: 'label',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      checked: {
        defaultValue: null,
        description: '',
        name: 'checked',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      onChange: {
        defaultValue: null,
        description: '',
        name: 'onChange',
        parent: undefined,
        required: true,
        type: {
          name: '(event: any) => void'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      compressed: {
        defaultValue: null,
        description: '',
        name: 'compressed',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"submit" | "reset" | "button"',
          value: [{
            value: '"submit"'
          }, {
            value: '"reset"'
          }, {
            value: '"button"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}