/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiHeaderSection } from './header_section';
export { EuiHeaderSectionItem } from './header_section_item';
export { EuiHeaderSectionItemButton } from './header_section_item_button';

try {
  EuiHeaderSection.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderSection',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      side: {
        defaultValue: null,
        description: '',
        name: 'side',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      grow: {
        defaultValue: null,
        description: '',
        name: 'grow',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiHeaderSectionItem.__docgenInfo = {
    description: '',
    displayName: 'EuiHeaderSectionItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      border: {
        defaultValue: null,
        description: 'Side to display a short border on.\nNot supported in Amsterdam theme.',
        name: 'border',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"left" | "right" | "none"',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"none"'
          }]
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}