/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiImage } from './image';

try {
  EuiImage.__docgenInfo = {
    description: '',
    displayName: 'EuiImage',
    methods: [],
    props: {
      alt: {
        defaultValue: null,
        description: 'Sepearate from the caption is a title on the alt tag itself.\nThis one is required for accessibility.',
        name: 'alt',
        parent: {
          fileName: 'eui/src/components/image/image.tsx',
          name: 'EuiImageProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      size: {
        defaultValue: null,
        description: 'Accepts `s` / `m` / `l` / `xl` / `original` / `fullWidth` / or a CSS size of `number` or `string`.\n`fullWidth` will set the figure to stretch to 100% of its container.\n`string` and `number` types will max both the width or height, whichever is greater.',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/image/image.tsx',
          name: 'EuiImageProps'
        },
        required: false,
        type: {
          name: 'string | number'
        }
      },
      fullScreenIconColor: {
        defaultValue: null,
        description: 'Changes the color of the icon that floats above the image when it can be clicked to fullscreen.\nThe default value of `light` is fine unless your image has a white background, in which case you should change it to `dark`.',
        name: 'fullScreenIconColor',
        parent: {
          fileName: 'eui/src/components/image/image.tsx',
          name: 'EuiImageProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'FullScreenIconColor',
          value: [{
            value: '"light"'
          }, {
            value: '"dark"'
          }]
        }
      },
      url: {
        defaultValue: null,
        description: '',
        name: 'url',
        parent: {
          fileName: 'eui/src/components/image/image.tsx',
          name: 'EuiImageProps'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      caption: {
        defaultValue: null,
        description: 'Provides the visible caption to the image',
        name: 'caption',
        parent: {
          fileName: 'eui/src/components/image/image.tsx',
          name: 'EuiImageProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      hasShadow: {
        defaultValue: null,
        description: 'When set to `true` (default) will apply a slight shadow to the image',
        name: 'hasShadow',
        parent: {
          fileName: 'eui/src/components/image/image.tsx',
          name: 'EuiImageProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      allowFullScreen: {
        defaultValue: null,
        description: 'When set to `true` will make the image clickable to a larger version',
        name: 'allowFullScreen',
        parent: {
          fileName: 'eui/src/components/image/image.tsx',
          name: 'EuiImageProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}