/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiLink } from './link';

try {
  EuiLink.__docgenInfo = {
    description: '',
    displayName: 'EuiLink',
    methods: [],
    props: {
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: {
          fileName: 'eui/src/components/link/link.tsx',
          name: 'EuiLinkAnchorProps'
        },
        required: false,
        type: {
          name: '((event: MouseEvent<HTMLButtonElement, MouseEvent>) => void) | ((event: MouseEvent<HTMLAnchorElement, MouseEvent>) => void)'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/link/link.tsx',
          name: 'LinkAnchorProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"submit" | "reset" | "button"',
          value: [{
            value: '"submit"'
          }, {
            value: '"reset"'
          }, {
            value: '"button"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/link/link.tsx',
          name: 'LinkAnchorProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiLinkColor',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }, {
            value: '"accent"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      external: {
        defaultValue: null,
        description: 'Set to true to show an icon indicating that it is an external link.',
        name: 'external',
        parent: {
          fileName: 'eui/src/components/link/link.tsx',
          name: 'LinkAnchorProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}