/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiListGroup } from './list_group';
export { EuiListGroupItem } from './list_group_item';
export { EuiPinnableListGroup } from './pinnable_list_group';

try {
  EuiListGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiListGroup',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      bordered: {
        defaultValue: null,
        description: 'Add a border to the list container',
        name: 'bordered',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      flush: {
        defaultValue: null,
        description: 'Remove container padding, stretching list items to the edges',
        name: 'flush',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      gutterSize: {
        defaultValue: null,
        description: 'Spacing between list items',
        name: 'gutterSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'GutterSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }]
        }
      },
      listItems: {
        defaultValue: null,
        description: 'Items to display in this group. See #EuiListGroupItem',
        name: 'listItems',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiListGroupItemProps[]'
        }
      },
      color: {
        defaultValue: null,
        description: 'Change the colors of all `listItems` at once',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'Color',
          value: [{
            value: '"primary"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }, {
            value: '"inherit"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Change the size of all `listItems` at once',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      maxWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the page,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'maxWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      showToolTips: {
        defaultValue: null,
        description: 'Display tooltips on all list items',
        name: 'showToolTips',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      wrapText: {
        defaultValue: null,
        description: 'Allow link text to wrap vs truncated',
        name: 'wrapText',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ariaLabelledby: {
        defaultValue: null,
        description: '',
        name: 'ariaLabelledby',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiListGroupItem.__docgenInfo = {
    description: '',
    displayName: 'EuiListGroupItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      size: {
        defaultValue: null,
        description: 'Size of the label text',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: 'By default the item will inherit the color of its wrapper (button/link/span),\notherwise pass one of the acceptable options',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'Color',
          value: [{
            value: '"primary"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }, {
            value: '"inherit"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      label: {
        defaultValue: null,
        description: 'Content to be displayed in the list item',
        name: 'label',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      isActive: {
        defaultValue: null,
        description: 'Apply styles indicating an item is active',
        name: 'isActive',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: 'Apply styles indicating an item is disabled',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      href: {
        defaultValue: null,
        description: 'Make the list item label a link.\nWhile permitted, `href` and `onClick` should not be used together in most cases and may create problems.',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      iconType: {
        defaultValue: null,
        description: 'Adds `EuiIcon` of `EuiIcon.type`',
        name: 'iconType',
        parent: undefined,
        required: false,
        type: {
          name: 'IconType'
        }
      },
      icon: {
        defaultValue: null,
        description: 'Custom node to pass as the icon. Cannot be used in conjunction\nwith `iconType`.',
        name: 'icon',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactElement'
        }
      },
      showToolTip: {
        defaultValue: null,
        description: 'Display tooltip on list item',
        name: 'showToolTip',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      extraAction: {
        defaultValue: null,
        description: 'Adds an `EuiButtonIcon` to the right side of the item; `iconType` is required;\npass `alwaysShow` if you don\'t want the default behavior of only showing on hover',
        name: 'extraAction',
        parent: undefined,
        required: false,
        type: {
          name: '{ type?: "submit" | "reset" | "button"; } & EuiButtonIconProps & { onClick?: (event: MouseEvent<HTMLButtonElement, MouseEvent>) => void; } & ButtonHTMLAttributes<...> & { ...; } & { ...; }'
        }
      },
      onClick: {
        defaultValue: null,
        description: 'Make the list item label a button.\nWhile permitted, `href` and `onClick` should not be used together in most cases and may create problems.',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      wrapText: {
        defaultValue: null,
        description: 'Allow link text to wrap',
        name: 'wrapText',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      buttonRef: {
        defaultValue: null,
        description: 'Pass-through ref reference specifically for targeting\ninstances where the item content is rendered as a `button`',
        name: 'buttonRef',
        parent: undefined,
        required: false,
        type: {
          name: 'any'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiPinnableListGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiPinnableListGroup',
    methods: [],
    props: {
      listItems: {
        defaultValue: null,
        description: 'Extends `EuiListGroupItemProps`, at the very least, expecting a `label`.\nSee #EuiPinnableListGroupItem',
        name: 'listItems',
        parent: {
          fileName: 'eui/src/components/list_group/pinnable_list_group/pinnable_list_group.tsx',
          name: 'EuiPinnableListGroupProps'
        },
        required: true,
        type: {
          name: 'EuiPinnableListGroupItemProps[]'
        }
      },
      onPinClick: {
        defaultValue: null,
        description: 'Shows the pin icon and calls this function on click.\nReturns `item: EuiPinnableListGroupItemProps`',
        name: 'onPinClick',
        parent: {
          fileName: 'eui/src/components/list_group/pinnable_list_group/pinnable_list_group.tsx',
          name: 'EuiPinnableListGroupProps'
        },
        required: true,
        type: {
          name: '(item: EuiPinnableListGroupItemProps) => void'
        }
      },
      pinTitle: {
        defaultValue: null,
        description: 'The pin icon needs a title/aria-label for accessibility.\nIt is a function that passes the item back and must return a string `(item) => string`.\nDefault is `"Pin item"`',
        name: 'pinTitle',
        parent: {
          fileName: 'eui/src/components/list_group/pinnable_list_group/pinnable_list_group.tsx',
          name: 'EuiPinnableListGroupProps'
        },
        required: false,
        type: {
          name: '(item: EuiPinnableListGroupItemProps) => string'
        }
      },
      unpinTitle: {
        defaultValue: null,
        description: 'The unpin icon needs a title/aria-label for accessibility.\nIt is a function that passes the item back and must return a string `(item) => string`.\nDefault is `"Unpin item"`',
        name: 'unpinTitle',
        parent: {
          fileName: 'eui/src/components/list_group/pinnable_list_group/pinnable_list_group.tsx',
          name: 'EuiPinnableListGroupProps'
        },
        required: false,
        type: {
          name: '(item: EuiPinnableListGroupItemProps) => string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      bordered: {
        defaultValue: null,
        description: 'Add a border to the list container',
        name: 'bordered',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      flush: {
        defaultValue: null,
        description: 'Remove container padding, stretching list items to the edges',
        name: 'flush',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      gutterSize: {
        defaultValue: null,
        description: 'Spacing between list items',
        name: 'gutterSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'GutterSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: 'Change the colors of all `listItems` at once',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'Color',
          value: [{
            value: '"primary"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }, {
            value: '"inherit"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Change the size of all `listItems` at once',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      maxWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the page,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'maxWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      showToolTips: {
        defaultValue: null,
        description: 'Display tooltips on all list items',
        name: 'showToolTips',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      wrapText: {
        defaultValue: null,
        description: 'Allow link text to wrap vs truncated',
        name: 'wrapText',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ariaLabelledby: {
        defaultValue: null,
        description: '',
        name: 'ariaLabelledby',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}