/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiPinnableListGroup } from './pinnable_list_group';

try {
  EuiPinnableListGroup.__docgenInfo = {
    description: '',
    displayName: 'EuiPinnableListGroup',
    methods: [],
    props: {
      listItems: {
        defaultValue: null,
        description: 'Extends `EuiListGroupItemProps`, at the very least, expecting a `label`.\nSee #EuiPinnableListGroupItem',
        name: 'listItems',
        parent: {
          fileName: 'eui/src/components/list_group/pinnable_list_group/pinnable_list_group.tsx',
          name: 'EuiPinnableListGroupProps'
        },
        required: true,
        type: {
          name: 'EuiPinnableListGroupItemProps[]'
        }
      },
      onPinClick: {
        defaultValue: null,
        description: 'Shows the pin icon and calls this function on click.\nReturns `item: EuiPinnableListGroupItemProps`',
        name: 'onPinClick',
        parent: {
          fileName: 'eui/src/components/list_group/pinnable_list_group/pinnable_list_group.tsx',
          name: 'EuiPinnableListGroupProps'
        },
        required: true,
        type: {
          name: '(item: EuiPinnableListGroupItemProps) => void'
        }
      },
      pinTitle: {
        defaultValue: null,
        description: 'The pin icon needs a title/aria-label for accessibility.\nIt is a function that passes the item back and must return a string `(item) => string`.\nDefault is `"Pin item"`',
        name: 'pinTitle',
        parent: {
          fileName: 'eui/src/components/list_group/pinnable_list_group/pinnable_list_group.tsx',
          name: 'EuiPinnableListGroupProps'
        },
        required: false,
        type: {
          name: '(item: EuiPinnableListGroupItemProps) => string'
        }
      },
      unpinTitle: {
        defaultValue: null,
        description: 'The unpin icon needs a title/aria-label for accessibility.\nIt is a function that passes the item back and must return a string `(item) => string`.\nDefault is `"Unpin item"`',
        name: 'unpinTitle',
        parent: {
          fileName: 'eui/src/components/list_group/pinnable_list_group/pinnable_list_group.tsx',
          name: 'EuiPinnableListGroupProps'
        },
        required: false,
        type: {
          name: '(item: EuiPinnableListGroupItemProps) => string'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      bordered: {
        defaultValue: null,
        description: 'Add a border to the list container',
        name: 'bordered',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      flush: {
        defaultValue: null,
        description: 'Remove container padding, stretching list items to the edges',
        name: 'flush',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      gutterSize: {
        defaultValue: null,
        description: 'Spacing between list items',
        name: 'gutterSize',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'GutterSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"none"'
          }]
        }
      },
      color: {
        defaultValue: null,
        description: 'Change the colors of all `listItems` at once',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'Color',
          value: [{
            value: '"primary"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }, {
            value: '"inherit"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      size: {
        defaultValue: null,
        description: 'Change the size of all `listItems` at once',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      maxWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the page,\nset to `true` to use the default size,\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'maxWidth',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      showToolTips: {
        defaultValue: null,
        description: 'Display tooltips on all list items',
        name: 'showToolTips',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      wrapText: {
        defaultValue: null,
        description: 'Allow link text to wrap vs truncated',
        name: 'wrapText',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      ariaLabelledby: {
        defaultValue: null,
        description: '',
        name: 'ariaLabelledby',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}