function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useMemo, Fragment } from 'react';
import PropTypes from "prop-types";
import { EuiLoadingSpinner } from '../loading';
import { EuiButtonEmpty, EuiButtonIcon } from '../button';
import { EuiOverlayMask } from '../overlay_mask';
import { EuiTitle } from '../title';
import { EuiModal, EuiModalBody, EuiModalHeader } from '../modal';
import { EuiI18n, useEuiI18n } from '../i18n';
import { EuiPopover, EuiPopoverTitle } from '../popover';
import { EuiText } from '../text';
import { EuiSpacer } from '../spacer'; // @ts-ignore a react svg

import MarkdownLogo from './icons/markdown_logo';
import { EuiHorizontalRule } from '../horizontal_rule';
import { EuiToolTip } from '../tool_tip';
export var EuiMarkdownEditorFooter = function EuiMarkdownEditorFooter(props) {
  var uiPlugins = props.uiPlugins,
      isUploadingFiles = props.isUploadingFiles,
      openFiles = props.openFiles,
      errors = props.errors,
      hasUnacceptedItems = props.hasUnacceptedItems,
      dropHandlers = props.dropHandlers;

  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      isShowingHelp = _useState2[0],
      setIsShowingHelp = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      isPopoverOpen = _useState4[0],
      setIsPopoverOpen = _useState4[1];

  var onButtonClick = function onButtonClick() {
    return setIsPopoverOpen(function (isPopoverOpen) {
      return !isPopoverOpen;
    });
  };

  var closePopover = function closePopover() {
    return setIsPopoverOpen(false);
  };

  var uploadButton;
  var supportedFileTypes = useMemo(function () {
    return dropHandlers.map(function (_ref) {
      var supportedFiles = _ref.supportedFiles;
      return supportedFiles.join(', ');
    }).sort().join(', ');
  }, [dropHandlers]);
  var ariaLabels = {
    uploadingFiles: useEuiI18n('euiMarkdownEditorFooter.uploadingFiles', 'Click to upload files'),
    openUploadModal: useEuiI18n('euiMarkdownEditorFooter.openUploadModal', 'Open upload files modal'),
    unsupportedFileType: useEuiI18n('euiMarkdownEditorFooter.unsupportedFileType', 'File type not supported'),
    supportedFileTypes: useEuiI18n('euiMarkdownEditorFooter.supportedFileTypes', 'Supported files: {supportedFileTypes}', {
      supportedFileTypes: supportedFileTypes
    }),
    showSyntaxErrors: useEuiI18n('euiMarkdownEditorFooter.showSyntaxErrors', 'Show errors'),
    showMarkdownHelp: useEuiI18n('euiMarkdownEditorFooter.showMarkdownHelp', 'Show markdown help')
  };

  if (isUploadingFiles) {
    uploadButton = React.createElement(EuiButtonIcon, {
      iconType: EuiLoadingSpinner,
      "aria-label": ariaLabels.uploadingFiles
    });
  } else if (dropHandlers.length > 0 && hasUnacceptedItems) {
    uploadButton = React.createElement(EuiToolTip, {
      content: ariaLabels.supportedFileTypes
    }, React.createElement(EuiButtonEmpty, {
      className: "euiMarkdownEditorFooter__uploadError",
      autoFocus: true,
      size: "xs",
      iconType: "paperClip",
      color: "danger",
      "aria-label": "".concat(ariaLabels.unsupportedFileType, ". ").concat(ariaLabels.supportedFileTypes, ". ").concat(ariaLabels.uploadingFiles),
      onClick: openFiles
    }, ariaLabels.unsupportedFileType));
  } else if (dropHandlers.length > 0) {
    uploadButton = React.createElement(EuiButtonIcon, {
      iconType: "paperClip",
      color: "text",
      "aria-label": ariaLabels.openUploadModal,
      onClick: openFiles
    });
  }

  var errorsButton;

  if (errors && errors.length) {
    errorsButton = React.createElement(EuiPopover, {
      button: React.createElement(EuiButtonEmpty, {
        iconType: "crossInACircleFilled",
        size: "s",
        color: "danger",
        "aria-label": ariaLabels.showSyntaxErrors,
        onClick: onButtonClick
      }, errors.length),
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      anchorPosition: "upCenter"
    }, React.createElement("div", {
      className: "euiMarkdownEditorFooter__popover"
    }, React.createElement(EuiPopoverTitle, null, React.createElement(EuiI18n, {
      token: "euiMarkdownEditorFooter.errorsTitle",
      default: "Errors"
    })), errors.map(function (message, idx) {
      return React.createElement(EuiText, {
        key: idx
      }, message.toString());
    })));
  }

  return React.createElement("div", {
    className: "euiMarkdownEditorFooter"
  }, React.createElement("div", {
    className: "euiMarkdownEditorFooter__actions"
  }, uploadButton, errorsButton), React.createElement(EuiButtonIcon, {
    className: "euiMarkdownEditorFooter__help",
    iconType: MarkdownLogo,
    color: "text",
    "aria-label": ariaLabels.showMarkdownHelp,
    onClick: function onClick() {
      return setIsShowingHelp(!isShowingHelp);
    }
  }), isShowingHelp && React.createElement(EuiOverlayMask, {
    onClick: function onClick() {
      return setIsShowingHelp(false);
    }
  }, React.createElement(EuiModal, {
    onClose: function onClose() {
      return setIsShowingHelp(false);
    }
  }, React.createElement(EuiModalHeader, null, React.createElement(EuiTitle, null, React.createElement("h3", null, React.createElement(EuiI18n, {
    token: "euiMarkdownEditorFooter.syntaxTitle",
    default: "Syntax help"
  })))), React.createElement(EuiModalBody, null, React.createElement(Fragment, null, React.createElement(EuiText, null, React.createElement(EuiI18n, {
    tokens: ['euiMarkdownEditorFooter.descriptionPrefix', 'euiMarkdownEditorFooter.descriptionSuffix'],
    defaults: ['This editor uses', 'You can also utilize these additional syntax plugins to add rich content to your text.']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        descriptionPrefix = _ref3[0],
        descriptionSuffix = _ref3[1];

    return React.createElement("p", null, descriptionPrefix, ' ', React.createElement("a", {
      href: "https://github.github.com/gfm/",
      target: "_blank"
    }, "Github flavored markdown"), ". ", descriptionSuffix);
  })), React.createElement(EuiHorizontalRule, null), uiPlugins.filter(function (_ref4) {
    var helpText = _ref4.helpText;
    return !!helpText;
  }).map(function (_ref5) {
    var name = _ref5.name,
        helpText = _ref5.helpText;
    return React.createElement(Fragment, {
      key: name
    }, React.createElement(EuiTitle, {
      size: "xxs"
    }, React.createElement("p", null, React.createElement("strong", null, name))), React.createElement(EuiSpacer, {
      size: "s"
    }), helpText, React.createElement(EuiSpacer, {
      size: "l"
    }));
  }))))));
};
EuiMarkdownEditorFooter.propTypes = {
  uiPlugins: PropTypes.arrayOf(PropTypes.shape({
    name: PropTypes.string.isRequired,
    button: PropTypes.shape({
      label: PropTypes.string.isRequired,
      iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]).isRequired
    }).isRequired,
    helpText: PropTypes.node,
    formatting: PropTypes.shape({
      prefix: PropTypes.string,
      suffix: PropTypes.string,
      blockPrefix: PropTypes.string,
      blockSuffix: PropTypes.string,
      multiline: PropTypes.bool,
      replaceNext: PropTypes.string,
      prefixSpace: PropTypes.bool,
      scanFor: PropTypes.string,
      surroundWithNewlines: PropTypes.bool,
      orderedList: PropTypes.bool,
      trimFirst: PropTypes.bool
    }),
    editor: PropTypes.elementType
  }).isRequired).isRequired,
  isUploadingFiles: PropTypes.bool.isRequired,
  openFiles: PropTypes.func.isRequired,
  errors: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.any.isRequired, PropTypes.any.isRequired]).isRequired).isRequired,
  hasUnacceptedItems: PropTypes.bool.isRequired,
  dropHandlers: PropTypes.arrayOf(PropTypes.shape({
    supportedFiles: PropTypes.arrayOf(PropTypes.string.isRequired).isRequired,
    accepts: PropTypes.func.isRequired,
    getFormattingForItem: PropTypes.func.isRequired
  }).isRequired).isRequired
};

try {
  EuiMarkdownEditorFooter.__docgenInfo = {
    description: '',
    displayName: 'EuiMarkdownEditorFooter',
    methods: [],
    props: {
      uiPlugins: {
        defaultValue: null,
        description: '',
        name: 'uiPlugins',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_editor_footer.tsx',
          name: 'EuiMarkdownEditorFooterProps'
        },
        required: true,
        type: {
          name: 'EuiMarkdownEditorUiPlugin<any>[]'
        }
      },
      isUploadingFiles: {
        defaultValue: null,
        description: '',
        name: 'isUploadingFiles',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_editor_footer.tsx',
          name: 'EuiMarkdownEditorFooterProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      openFiles: {
        defaultValue: null,
        description: '',
        name: 'openFiles',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_editor_footer.tsx',
          name: 'EuiMarkdownEditorFooterProps'
        },
        required: true,
        type: {
          name: '() => void'
        }
      },
      errors: {
        defaultValue: null,
        description: '',
        name: 'errors',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_editor_footer.tsx',
          name: 'EuiMarkdownEditorFooterProps'
        },
        required: true,
        type: {
          name: 'EuiMarkdownParseError[]'
        }
      },
      hasUnacceptedItems: {
        defaultValue: null,
        description: '',
        name: 'hasUnacceptedItems',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_editor_footer.tsx',
          name: 'EuiMarkdownEditorFooterProps'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      dropHandlers: {
        defaultValue: null,
        description: '',
        name: 'dropHandlers',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_editor_footer.tsx',
          name: 'EuiMarkdownEditorFooterProps'
        },
        required: true,
        type: {
          name: 'EuiMarkdownDropHandler[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}