function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useContext } from 'react';
import PropTypes from "prop-types";
import { EuiButtonEmpty, EuiButtonIcon } from '../button';
import { EuiI18n } from '../i18n';
import { EuiToolTip } from '../tool_tip';
import { MODE_VIEWING } from './markdown_modes';
import { EuiMarkdownContext } from './markdown_context';
// @ts-ignore a react svg
import MarkdownCheckmarkIcon from './icons/markdown_checkmark';
var boldItalicButtons = [{
  id: 'mdBold',
  label: 'Bold',
  name: 'bold',
  iconType: 'editorBold'
}, {
  id: 'mdItalic',
  label: 'Italic',
  name: 'italic',
  iconType: 'editorItalic'
}];
var listButtons = [{
  id: 'mdUl',
  label: 'Unordered list',
  name: 'ul',
  iconType: 'editorUnorderedList'
}, {
  id: 'mdOl',
  label: 'Ordered list',
  name: 'ol',
  iconType: 'editorOrderedList'
}, {
  id: 'mdTl',
  label: 'Task list',
  name: 'tl',
  iconType: MarkdownCheckmarkIcon
}];
var quoteCodeLinkButtons = [{
  id: 'mdQuote',
  label: 'Quote',
  name: 'quote',
  iconType: 'quote'
}, {
  id: 'mdCode',
  label: 'Code',
  name: 'code',
  iconType: 'editorCodeBlock'
}, {
  id: 'mdLink',
  label: 'Link',
  name: 'link',
  iconType: 'editorLink'
}];
export var EuiMarkdownEditorToolbar = function EuiMarkdownEditorToolbar(_ref) {
  var markdownActions = _ref.markdownActions,
      viewMode = _ref.viewMode,
      onClickPreview = _ref.onClickPreview,
      uiPlugins = _ref.uiPlugins,
      selectedNode = _ref.selectedNode;

  var _useContext = useContext(EuiMarkdownContext),
      openPluginEditor = _useContext.openPluginEditor;

  var handleMdButtonClick = function handleMdButtonClick(mdButtonId) {
    var actionResult = markdownActions.do(mdButtonId);
    if (actionResult !== true) openPluginEditor(actionResult);
  };

  var isPreviewing = viewMode === MODE_VIEWING;
  return React.createElement("div", {
    className: "euiMarkdownEditorToolbar"
  }, React.createElement("div", {
    className: "euiMarkdownEditorToolbar__buttons"
  }, boldItalicButtons.map(function (item) {
    return React.createElement(EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, React.createElement(EuiButtonIcon, {
      color: "text",
      onClick: function onClick() {
        return handleMdButtonClick(item.id);
      },
      iconType: item.iconType,
      "aria-label": item.label,
      isDisabled: isPreviewing
    }));
  }), React.createElement("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), listButtons.map(function (item) {
    return React.createElement(EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, React.createElement(EuiButtonIcon, {
      color: "text",
      onClick: function onClick() {
        return handleMdButtonClick(item.id);
      },
      iconType: item.iconType,
      "aria-label": item.label,
      isDisabled: isPreviewing
    }));
  }), React.createElement("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), quoteCodeLinkButtons.map(function (item) {
    return React.createElement(EuiToolTip, {
      key: item.id,
      content: item.label,
      delay: "long"
    }, React.createElement(EuiButtonIcon, {
      color: "text",
      onClick: function onClick() {
        return handleMdButtonClick(item.id);
      },
      iconType: item.iconType,
      "aria-label": item.label,
      isDisabled: isPreviewing
    }));
  }), uiPlugins.length > 0 ? React.createElement(React.Fragment, null, React.createElement("span", {
    className: "euiMarkdownEditorToolbar__divider"
  }), uiPlugins.map(function (_ref2) {
    var name = _ref2.name,
        button = _ref2.button;
    var isSelectedNodeType = selectedNode && selectedNode.type === name;
    return React.createElement(EuiToolTip, {
      key: name,
      content: button.label,
      delay: "long"
    }, React.createElement(EuiButtonIcon, _extends({
      color: "text"
    }, isSelectedNodeType ? {
      style: {
        background: 'rgba(0, 0, 0, 0.15)'
      }
    } : null, {
      onClick: function onClick() {
        return handleMdButtonClick(name);
      },
      iconType: button.iconType,
      "aria-label": button.label,
      isDisabled: isPreviewing
    })));
  })) : null), isPreviewing ? React.createElement(EuiButtonEmpty, {
    iconType: "editorCodeBlock",
    color: "text",
    size: "s",
    onClick: onClickPreview
  }, React.createElement(EuiI18n, {
    token: "euiMarkdownEditorToolbar.editor",
    default: "Editor"
  })) : React.createElement(EuiButtonEmpty, {
    iconType: "eye",
    color: "text",
    size: "s",
    onClick: onClickPreview
  }, React.createElement(EuiI18n, {
    token: "euiMarkdownEditorToolbar.previewMarkdown",
    default: "Preview"
  })));
};
EuiMarkdownEditorToolbar.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  selectedNode: PropTypes.oneOfType([PropTypes.oneOf([null]), PropTypes.any.isRequired]),
  markdownActions: PropTypes.any.isRequired,
  viewMode: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.any.isRequired]).isRequired,
  onClickPreview: PropTypes.func.isRequired,
  uiPlugins: PropTypes.arrayOf(PropTypes.shape({
    name: PropTypes.string.isRequired,
    button: PropTypes.shape({
      label: PropTypes.string.isRequired,
      iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]).isRequired
    }).isRequired,
    helpText: PropTypes.node,
    formatting: PropTypes.shape({
      prefix: PropTypes.string,
      suffix: PropTypes.string,
      blockPrefix: PropTypes.string,
      blockSuffix: PropTypes.string,
      multiline: PropTypes.bool,
      replaceNext: PropTypes.string,
      prefixSpace: PropTypes.bool,
      scanFor: PropTypes.string,
      surroundWithNewlines: PropTypes.bool,
      orderedList: PropTypes.bool,
      trimFirst: PropTypes.bool
    }),
    editor: PropTypes.elementType
  }).isRequired).isRequired
};

try {
  EuiMarkdownEditorToolbar.__docgenInfo = {
    description: '',
    displayName: 'EuiMarkdownEditorToolbar',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      selectedNode: {
        defaultValue: null,
        description: '',
        name: 'selectedNode',
        parent: undefined,
        required: false,
        type: {
          name: 'any'
        }
      },
      markdownActions: {
        defaultValue: null,
        description: '',
        name: 'markdownActions',
        parent: undefined,
        required: true,
        type: {
          name: 'MarkdownActions'
        }
      },
      viewMode: {
        defaultValue: null,
        description: '',
        name: 'viewMode',
        parent: undefined,
        required: true,
        type: {
          name: 'enum',
          raw: 'MARKDOWN_MODE',
          value: [{
            value: '"editing"'
          }, {
            value: '"viewing"'
          }]
        }
      },
      onClickPreview: {
        defaultValue: null,
        description: '',
        name: 'onClickPreview',
        parent: undefined,
        required: true,
        type: {
          name: '(event: MouseEvent<HTMLButtonElement, MouseEvent>) => void'
        }
      },
      uiPlugins: {
        defaultValue: null,
        description: '',
        name: 'uiPlugins',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiMarkdownEditorUiPlugin<any>[]'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}