/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useMemo } from 'react';
import PropTypes from "prop-types";
import unified from 'unified';
import { defaultProcessingPlugins, defaultParsingPlugins } from './plugins/markdown_default_plugins';
export var EuiMarkdownFormat = function EuiMarkdownFormat(_ref) {
  var children = _ref.children,
      _ref$parsingPluginLis = _ref.parsingPluginList,
      parsingPluginList = _ref$parsingPluginLis === void 0 ? defaultParsingPlugins : _ref$parsingPluginLis,
      _ref$processingPlugin = _ref.processingPluginList,
      processingPluginList = _ref$processingPlugin === void 0 ? defaultProcessingPlugins : _ref$processingPlugin;
  var processor = useMemo(function () {
    return unified().use(parsingPluginList).use(processingPluginList);
  }, [parsingPluginList, processingPluginList]);
  var result = useMemo(function () {
    try {
      return processor.processSync(children).contents;
    } catch (e) {
      return children;
    }
  }, [children, processor]);
  return React.createElement("div", {
    className: "euiMarkdownFormat"
  }, result);
};
EuiMarkdownFormat.propTypes = {
  children: PropTypes.string.isRequired,

  /** array of unified plugins to parse content into an AST */
  parsingPluginList: PropTypes.any,

  /** array of unified plugins to convert the AST into a ReactNode */
  processingPluginList: PropTypes.any
};

try {
  EuiMarkdownFormat.__docgenInfo = {
    description: '',
    displayName: 'EuiMarkdownFormat',
    methods: [],
    props: {
      parsingPluginList: {
        defaultValue: {
          value: null
        },
        description: 'array of unified plugins to parse content into an AST',
        name: 'parsingPluginList',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_format.tsx',
          name: 'EuiMarkdownFormatProps'
        },
        required: false,
        type: {
          name: 'PluggableList<Settings>'
        }
      },
      processingPluginList: {
        defaultValue: {
          value: null
        },
        description: 'array of unified plugins to convert the AST into a ReactNode',
        name: 'processingPluginList',
        parent: {
          fileName: 'eui/src/components/markdown_editor/markdown_format.tsx',
          name: 'EuiMarkdownFormatProps'
        },
        required: false,
        type: {
          name: 'PluggableList<Settings>'
        }
      }
    },
    extends: []
  };
} catch (e) {}