function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

import PropTypes from "prop-types";

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useContext } from 'react';
import { EuiCheckbox } from '../../form/checkbox';
import { EuiMarkdownContext } from '../markdown_context';
import { htmlIdGenerator } from '../../../services/accessibility';

var CheckboxParser = function CheckboxParser() {
  var Parser = this.Parser;
  var tokenizers = Parser.prototype.blockTokenizers;
  var methods = Parser.prototype.blockMethods;

  var tokenizeCheckbox = function tokenizeCheckbox(eat, value, silent) {
    /**
     * optional leading whitespace & single (dash or asterisk) mix
     * square brackets, optionally containing whitespace and `x`
     * optional whitespace
     * remainder of the line is consumed as the textbox label
     */
    var checkboxMatch = value.match(/^(\s*[-*]\s*)?\[([\sx]*)\](.+)/);
    if (checkboxMatch == null) return false;

    if (silent) {
      return true;
    }

    var _checkboxMatch = _slicedToArray(checkboxMatch, 4),
        match = _checkboxMatch[0],
        _checkboxMatch$ = _checkboxMatch[1],
        lead = _checkboxMatch$ === void 0 ? '' : _checkboxMatch$,
        checkboxStatus = _checkboxMatch[2],
        text = _checkboxMatch[3];

    var isChecked = checkboxStatus.indexOf('x') !== -1;
    var now = eat.now();
    var offset = match.length - text.length;
    now.column += offset;
    now.offset += offset;
    var children = this.tokenizeInline(text, now);
    return eat(match)({
      type: 'checkboxPlugin',
      lead: lead,
      label: text,
      isChecked: isChecked,
      children: children
    });
  };

  tokenizers.checkbox = tokenizeCheckbox;
  methods.splice(methods.indexOf('list'), 0, 'checkbox'); // Run it just before default `list` plugin to inject our own idea of checkboxes.
};

var CheckboxMarkdownRenderer = function CheckboxMarkdownRenderer(_ref) {
  var position = _ref.position,
      lead = _ref.lead,
      label = _ref.label,
      isChecked = _ref.isChecked,
      children = _ref.children;

  var _useContext = useContext(EuiMarkdownContext),
      replaceNode = _useContext.replaceNode;

  return React.createElement(EuiCheckbox, {
    id: htmlIdGenerator()(),
    checked: isChecked,
    label: children,
    onChange: function onChange() {
      replaceNode(position, "".concat(lead, "[").concat(isChecked ? ' ' : 'x', "]").concat(label));
    }
  });
};

CheckboxMarkdownRenderer.propTypes = {
  type: PropTypes.oneOf(["checkboxPlugin"]).isRequired,
  lead: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  isChecked: PropTypes.bool.isRequired,
  position: PropTypes.shape({
    start: PropTypes.shape({
      line: PropTypes.number.isRequired,
      column: PropTypes.number.isRequired,
      offset: PropTypes.number.isRequired
    }).isRequired,
    end: PropTypes.shape({
      line: PropTypes.number.isRequired,
      column: PropTypes.number.isRequired,
      offset: PropTypes.number.isRequired
    }).isRequired
  }).isRequired
};
export { CheckboxParser as parser, CheckboxMarkdownRenderer as renderer };

try {
  Attacher.__docgenInfo = {
    description: 'An attacher is the thing passed to `use`.\nIt configures the processor and in turn can receive options.\n\nAttachers can configure processors, such as by interacting with parsers and compilers, linking them to other processors, or by specifying how the syntax tree is handled.\n@param settings Configuration\n@typeParam S Plugin settings\n@typeParam P Processor settings\n@returns Optional Transformer.',
    displayName: 'Attacher',
    methods: [],
    props: {
      '0': {
        defaultValue: null,
        description: '',
        name: '0',
        parent: undefined,
        required: false,
        type: {
          name: 'Settings'
        }
      },
      length: {
        defaultValue: null,
        description: '',
        name: 'length',
        parent: undefined,
        required: true,
        type: {
          name: '0 | 1'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  CheckboxMarkdownRenderer.__docgenInfo = {
    description: '',
    displayName: 'CheckboxMarkdownRenderer',
    methods: [],
    props: {
      type: {
        defaultValue: null,
        description: '',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/markdown_editor/plugins/markdown_checkbox.tsx',
          name: 'CheckboxNodeDetails'
        },
        required: true,
        type: {
          name: '"checkboxPlugin"'
        }
      },
      lead: {
        defaultValue: null,
        description: '',
        name: 'lead',
        parent: {
          fileName: 'eui/src/components/markdown_editor/plugins/markdown_checkbox.tsx',
          name: 'CheckboxNodeDetails'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: {
          fileName: 'eui/src/components/markdown_editor/plugins/markdown_checkbox.tsx',
          name: 'CheckboxNodeDetails'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      isChecked: {
        defaultValue: null,
        description: '',
        name: 'isChecked',
        parent: {
          fileName: 'eui/src/components/markdown_editor/plugins/markdown_checkbox.tsx',
          name: 'CheckboxNodeDetails'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiMarkdownAstNodePosition'
        }
      }
    },
    extends: []
  };
} catch (e) {}