/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiConfirmModal, CONFIRM_BUTTON as EUI_MODAL_CONFIRM_BUTTON, CANCEL_BUTTON as EUI_MODAL_CANCEL_BUTTON } from './confirm_modal';
export { EuiModal } from './modal';
export { EuiModalFooter } from './modal_footer';
export { EuiModalHeader } from './modal_header';
export { EuiModalBody } from './modal_body';
export { EuiModalHeaderTitle } from './modal_header_title';

try {
  EuiConfirmModal.__docgenInfo = {
    description: '',
    displayName: 'EuiConfirmModal',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      title: {
        defaultValue: null,
        description: '',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      cancelButtonText: {
        defaultValue: null,
        description: '',
        name: 'cancelButtonText',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      confirmButtonText: {
        defaultValue: null,
        description: '',
        name: 'confirmButtonText',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onCancel: {
        defaultValue: null,
        description: '',
        name: 'onCancel',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: true,
        type: {
          name: '(event?: any) => void'
        }
      },
      onConfirm: {
        defaultValue: null,
        description: '',
        name: 'onConfirm',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: '(event: any) => void'
        }
      },
      confirmButtonDisabled: {
        defaultValue: null,
        description: '',
        name: 'confirmButtonDisabled',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      defaultFocusedButton: {
        defaultValue: null,
        description: '',
        name: 'defaultFocusedButton',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"confirm" | "cancel"',
          value: [{
            value: '"confirm"'
          }, {
            value: '"cancel"'
          }]
        }
      },
      buttonColor: {
        defaultValue: null,
        description: '',
        name: 'buttonColor',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonColor',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"ghost"'
          }, {
            value: '"text"'
          }]
        }
      },
      maxWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the modal.\nSet to `true` to use the default (`euiBreakpoints \'m\'`),\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'maxWidth',
        parent: {
          fileName: 'eui/src/components/modal/confirm_modal.tsx',
          name: 'EuiConfirmModalProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiModal.__docgenInfo = {
    description: '',
    displayName: 'EuiModal',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/modal/modal.tsx',
          name: 'EuiModalProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      onClose: {
        defaultValue: null,
        description: '',
        name: 'onClose',
        parent: {
          fileName: 'eui/src/components/modal/modal.tsx',
          name: 'EuiModalProps'
        },
        required: true,
        type: {
          name: '(event?: any) => void'
        }
      },
      maxWidth: {
        defaultValue: null,
        description: 'Sets the max-width of the modal.\nSet to `true` to use the default (`euiBreakpoints \'m\'`),\nset to `false` to not restrict the width,\nset to a number for a custom width in px,\nset to a string for a custom width in custom measurement.',
        name: 'maxWidth',
        parent: {
          fileName: 'eui/src/components/modal/modal.tsx',
          name: 'EuiModalProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean'
        }
      },
      initialFocus: {
        defaultValue: null,
        description: 'specifies what element should initially have focus; Can be a DOM node, or a selector string (which will be passed to document.querySelector() to find the DOM node), or a function that returns a DOM node.',
        name: 'initialFocus',
        parent: {
          fileName: 'eui/src/components/modal/modal.tsx',
          name: 'EuiModalProps'
        },
        required: false,
        type: {
          name: 'string | HTMLElement | (() => HTMLElement)'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiModalFooter.__docgenInfo = {
    description: '',
    displayName: 'EuiModalFooter',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiModalHeader.__docgenInfo = {
    description: '',
    displayName: 'EuiModalHeader',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiModalBody.__docgenInfo = {
    description: '',
    displayName: 'EuiModalBody',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiModalHeaderTitle.__docgenInfo = {
    description: '',
    displayName: 'EuiModalHeaderTitle',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}