function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component, createRef, isValidElement } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiListGroup, EuiListGroupItem } from '../list_group';
import { EuiNavDrawerFlyout } from './nav_drawer_flyout';
import { EuiNavDrawerGroup, ATTR_SELECTOR } from './nav_drawer_group';
import { EuiOutsideClickDetector } from '../outside_click_detector';
import { EuiI18n } from '../i18n';
import { EuiFlexItem, EuiFlexGroup } from '../flex';
import { throttle } from '../color_picker/utils';
var MENU_ELEMENT_ID = 'navDrawerMenu';
export var EuiNavDrawer =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiNavDrawer, _Component);

  function EuiNavDrawer() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, EuiNavDrawer);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(EuiNavDrawer)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "state", {
      flyoutIsCollapsed: true,
      flyoutListItems: null,
      focusReturnRef: null,
      isCollapsed: !_this.props.isLocked,
      isLocked: Boolean(_this.props.isLocked),
      isManagingFocus: false,
      navFlyoutTitle: undefined,
      outsideClickDisabled: true,
      toolTipsEnabled: true
    });

    _defineProperty(_assertThisInitialized(_this), "expandButtonRef", createRef());

    _defineProperty(_assertThisInitialized(_this), "returnOnIsLockedUpdate", function (isLockedState) {
      if (_this.props.onIsLockedUpdate) {
        _this.props.onIsLockedUpdate(isLockedState);
      }
    });

    _defineProperty(_assertThisInitialized(_this), "functionToCallOnWindowResize", throttle(function () {
      if (window.innerWidth < 1200) {
        _this.collapseDrawer();

        _this.collapseFlyout();
      } // reacts every 50ms to resize changes and always gets the final update

    }, 50));

    _defineProperty(_assertThisInitialized(_this), "sideNavLockClicked", function () {
      var isLocked = _this.state.isLocked;

      if (isLocked) {
        window.removeEventListener('resize', _this.functionToCallOnWindowResize);
      } else {
        window.addEventListener('resize', _this.functionToCallOnWindowResize);
      }

      _this.returnOnIsLockedUpdate(!isLocked);

      _this.setState({
        isLocked: !isLocked,
        isCollapsed: false,
        outsideClickDisabled: !isLocked
      });
    });

    _defineProperty(_assertThisInitialized(_this), "toggleOpen", function () {
      _this.setState(function (_ref) {
        var isCollapsed = _ref.isCollapsed;
        return {
          isCollapsed: !isCollapsed
        };
      }, function () {
        _this.setState(function (_ref2) {
          var isCollapsed = _ref2.isCollapsed;
          return {
            outsideClickDisabled: isCollapsed,
            toolTipsEnabled: isCollapsed
          };
        });
      });
    });

    _defineProperty(_assertThisInitialized(_this), "collapseButtonClick", function () {
      if (_this.state.isCollapsed) {
        _this.expandDrawer();
      } else {
        _this.collapseDrawer();
      }

      _this.collapseFlyout();

      requestAnimationFrame(function () {
        if (_this.expandButtonRef.current) {
          _this.expandButtonRef.current.focus();
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "expandDrawer", function () {
      _this.setState({
        isCollapsed: false,
        outsideClickDisabled: false
      });

      setTimeout(function () {
        _this.setState({
          toolTipsEnabled: false
        });
      }, 150);
    });

    _defineProperty(_assertThisInitialized(_this), "collapseDrawer", function () {
      _this.setState({
        isCollapsed: true,
        outsideClickDisabled: _this.state.flyoutIsCollapsed ? true : false,
        toolTipsEnabled: true,
        isLocked: false
      });

      _this.returnOnIsLockedUpdate(false); // Scrolls the menu and flyout back to top when the nav drawer collapses


      setTimeout(function () {
        var element = document.getElementById('navDrawerMenu');

        if (element) {
          element.scrollTop = 0;
        }
      }, 50); // In case it was locked before, remove the window resize listener

      window.removeEventListener('resize', _this.functionToCallOnWindowResize);
    });

    _defineProperty(_assertThisInitialized(_this), "expandFlyout", function (links, title, item) {
      if (_this.state.navFlyoutTitle === title) {
        _this.collapseFlyout();
      } else {
        _this.setState(function (_ref3) {
          var isLocked = _ref3.isLocked;
          return {
            flyoutIsCollapsed: false,
            flyoutListItems: links,
            focusReturnRef: item.label,
            isCollapsed: isLocked ? false : true,
            navFlyoutTitle: title,
            outsideClickDisabled: false,
            toolTipsEnabled: false
          };
        }, function () {
          // Ideally this uses React `ref` instead of `querySelector`, but the menu composition
          // does not allow for deep `ref` element management at present
          var element = document.querySelector("#".concat(MENU_ELEMENT_ID, " [").concat(ATTR_SELECTOR, "='").concat(item.label, "']"));
          if (!element) return;
          element.setAttribute('aria-expanded', 'true');
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "collapseFlyout", function () {
      var shouldReturnFocus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
      var focusReturn = _this.state.focusReturnRef;

      _this.setState({
        flyoutIsCollapsed: true,
        navFlyoutTitle: undefined,
        flyoutListItems: null,
        toolTipsEnabled: _this.state.isLocked ? false : true,
        focusReturnRef: null
      }, function () {
        // Ideally this uses React `ref` instead of `querySelector`, but the menu composition
        // does not allow for deep `ref` element management at present
        var element = document.querySelector("#".concat(MENU_ELEMENT_ID, " [").concat(ATTR_SELECTOR, "='").concat(focusReturn, "']"));

        if (!element) {
          return;
        }

        requestAnimationFrame(function () {
          element.setAttribute('aria-expanded', 'false');
        });
        if (!shouldReturnFocus) return;
        requestAnimationFrame(function () {
          element.focus();
        });
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closeBoth", function () {
      if (!_this.state.isLocked) _this.collapseDrawer();

      _this.collapseFlyout(false);
    });

    _defineProperty(_assertThisInitialized(_this), "handleDrawerMenuClick", function (event) {
      // walk up e.target until either:
      // 1. a[href] - close the menu
      // 2. document.body - do nothing
      var element = event.target;

      while (element !== null && element !== document.body && (element.tagName !== 'A' || element.getAttribute('href') === undefined)) {
        element = element.parentElement;
      }

      if (element !== document.body) {
        // this is an anchor with an href
        _this.closeBoth();
      }
    });

    _defineProperty(_assertThisInitialized(_this), "modifyChildren", function (children) {
      // Loop through the EuiNavDrawer children (EuiListGroup, EuiHorizontalRules, etc)
      // Filter out falsy items
      var filteredChildren = React.Children.toArray(children);
      return React.Children.map(filteredChildren, function (child) {
        if (isValidElement(child)) {
          // Allow for Fragments by recursive modification
          if (child.type === React.Fragment) {
            return _this.modifyChildren(child.props.children);
          } // Check if child is an EuiNavDrawerGroup and if it does have a flyout, add the expand function


          if (child.type === EuiNavDrawerGroup) {
            return React.cloneElement(child, {
              flyoutMenuButtonClick: _this.expandFlyout,
              showToolTips: _this.state.toolTipsEnabled && _this.props.showToolTips
            });
          }
        }

        return child;
      });
    });

    return _this;
  }

  _createClass(EuiNavDrawer, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (this.props.isLocked) {
        window.addEventListener('resize', this.functionToCallOnWindowResize);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('resize', this.functionToCallOnWindowResize);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          showExpandButton = _this$props.showExpandButton,
          showToolTips = _this$props.showToolTips,
          isLocked = _this$props.isLocked,
          onIsLockedUpdate = _this$props.onIsLockedUpdate,
          rest = _objectWithoutProperties(_this$props, ["children", "className", "showExpandButton", "showToolTips", "isLocked", "onIsLockedUpdate"]);

      var classes = classNames('euiNavDrawer', {
        'euiNavDrawer-isCollapsed': this.state.isCollapsed,
        'euiNavDrawer-isExpanded': !this.state.isCollapsed,
        'euiNavDrawer-isLocked': this.state.isLocked,
        'euiNavDrawer-flyoutIsCollapsed': this.state.flyoutIsCollapsed,
        'euiNavDrawer-flyoutIsExpanded': !this.state.flyoutIsCollapsed
      }, className);
      var footerContent;

      if (showExpandButton) {
        footerContent = React.createElement(EuiListGroup, {
          className: "euiNavDrawer__expandButton",
          flush: true
        }, React.createElement(EuiI18n, {
          tokens: ['euiNavDrawer.sideNavCollapse', 'euiNavDrawer.sideNavExpand', 'euiNavDrawer.sideNavLockAriaLabel', 'euiNavDrawer.sideNavLockExpanded', 'euiNavDrawer.sideNavLockCollapsed'],
          defaults: ['Collapse', 'Expand', 'Dock navigation', 'Navigation is docked', 'Navigation is undocked']
        }, function (_ref4) {
          var _ref5 = _slicedToArray(_ref4, 5),
              sideNavCollapse = _ref5[0],
              sideNavExpand = _ref5[1],
              sideNavLockAriaLabel = _ref5[2],
              sideNavLockExpanded = _ref5[3],
              sideNavLockCollapsed = _ref5[4];

          return React.createElement(EuiListGroupItem, {
            buttonRef: _this2.expandButtonRef,
            className: _this2.state.isCollapsed ? 'navDrawerExpandButton-isCollapsed' : 'navDrawerExpandButton-isExpanded',
            "data-test-subj": _this2.state.isCollapsed ? 'navDrawerExpandButton-isCollapsed' : 'navDrawerExpandButton-isExpanded',
            extraAction: {
              'aria-label': sideNavLockAriaLabel,
              'aria-pressed': _this2.state.isLocked ? true : false,
              className: 'euiNavDrawer__expandButtonLockAction',
              color: 'text',
              iconType: _this2.state.isLocked ? 'lock' : 'lockOpen',
              iconSize: 's',
              onClick: _this2.sideNavLockClicked,
              title: _this2.state.isLocked ? sideNavLockExpanded : sideNavLockCollapsed
            },
            iconType: _this2.state.isCollapsed ? 'menuRight' : 'menuLeft',
            label: _this2.state.isCollapsed ? sideNavExpand : sideNavCollapse,
            onClick: _this2.collapseButtonClick,
            showToolTip: _this2.state.isCollapsed,
            size: "s"
          });
        }));
      }

      var flyoutContent = React.createElement(EuiNavDrawerFlyout, {
        id: "navDrawerFlyout",
        isCollapsed: this.state.flyoutIsCollapsed,
        listItems: this.state.flyoutListItems,
        onClose: this.collapseFlyout,
        title: this.state.navFlyoutTitle,
        wrapText: true
      }); // Add an onClick that expands the flyout sub menu for any list items (links) that have a flyoutMenu prop (sub links)

      var modifiedChildren = children;
      modifiedChildren = this.modifyChildren(this.props.children);
      var menuClasses = classNames('euiNavDrawerMenu', {
        'euiNavDrawerMenu-hasFooter': footerContent
      });
      return React.createElement(EuiOutsideClickDetector, {
        onOutsideClick: function onOutsideClick() {
          return _this2.closeBoth();
        },
        isDisabled: this.state.outsideClickDisabled
      }, React.createElement("nav", _extends({
        className: classes
      }, rest), React.createElement(EuiFlexGroup, {
        gutterSize: "none",
        responsive: false
      }, React.createElement(EuiFlexItem, {
        grow: false
      }, React.createElement("div", {
        id: MENU_ELEMENT_ID,
        className: menuClasses,
        onClick: this.handleDrawerMenuClick
      }, footerContent, modifiedChildren)), flyoutContent)));
    }
  }]);

  return EuiNavDrawer;
}(Component);

_defineProperty(EuiNavDrawer, "defaultProps", {
  showExpandButton: true,
  showToolTips: true
});

EuiNavDrawer.propTypes = {
  /**
     * One or more ReactNodes to render as this component's content
     */
  children: PropTypes.oneOfType([PropTypes.node.isRequired, PropTypes.arrayOf(PropTypes.node.isRequired).isRequired]),

  /**
     * Keep drawer locked open by default
     */
  isLocked: PropTypes.bool,

  /**
     * Returns the current state of isLocked
     */
  onIsLockedUpdate: PropTypes.func,

  /**
     * Adds fixed toggle button to bottom of menu area
     */
  showExpandButton: PropTypes.bool,

  /**
     * Display tooltips on side nav items
     */
  showToolTips: PropTypes.bool,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};

try {
  EuiNavDrawer.__docgenInfo = {
    description: '',
    displayName: 'EuiNavDrawer',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'One or more ReactNodes to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: 'string | number | boolean | {} | ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<...>)> | ReactNodeArray | ReactPortal | ReactNode[]'
        }
      },
      isLocked: {
        defaultValue: null,
        description: 'Keep drawer locked open by default',
        name: 'isLocked',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onIsLockedUpdate: {
        defaultValue: null,
        description: 'Returns the current state of isLocked',
        name: 'onIsLockedUpdate',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: '(isLocked: boolean) => void'
        }
      },
      showExpandButton: {
        defaultValue: {
          value: 'true'
        },
        description: 'Adds fixed toggle button to bottom of menu area',
        name: 'showExpandButton',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showToolTips: {
        defaultValue: {
          value: 'true'
        },
        description: 'Display tooltips on side nav items',
        name: 'showToolTips',
        parent: {
          fileName: 'eui/src/components/nav_drawer/nav_drawer.tsx',
          name: 'EuiNavDrawerProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}