/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiResizeObserver, useResizeObserver } from './resize_observer';

try {
  EuiResizeObserver.__docgenInfo = {
    description: '',
    displayName: 'EuiResizeObserver',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'ReactNode to render as this component\'s content',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/observer/resize_observer/resize_observer.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: '(ref: (e: HTMLElement) => void) => ReactNode'
        }
      },
      onResize: {
        defaultValue: null,
        description: '',
        name: 'onResize',
        parent: {
          fileName: 'eui/src/components/observer/resize_observer/resize_observer.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: '(dimensions: { height: number; width: number; }) => void'
        }
      }
    },
    extends: []
  };
} catch (e) {}