function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiI18n } from '../i18n';
import { isNil } from '../../services/predicate';
var sizeToClassNameMap = {
  xs: 'euiProgress--xs',
  s: 'euiProgress--s',
  m: 'euiProgress--m',
  l: 'euiProgress--l'
};
export var SIZES = Object.keys(sizeToClassNameMap);
var colorToClassNameMap = {
  primary: 'euiProgress--primary',
  secondary: 'euiProgress--secondary',
  danger: 'euiProgress--danger',
  subdued: 'euiProgress--subdued',
  accent: 'euiProgress--accent'
};
export var COLORS = Object.keys(colorToClassNameMap);
var dataColorToClassNameMap = {
  primary: 'euiProgress__data--primary',
  secondary: 'euiProgress__data--secondary',
  danger: 'euiProgress__data--danger',
  subdued: 'euiProgress__data--subdued',
  accent: 'euiProgress__data--accent'
};
var positionsToClassNameMap = {
  fixed: 'euiProgress--fixed',
  absolute: 'euiProgress--absolute',
  static: ''
};
export var POSITIONS = Object.keys(positionsToClassNameMap);
export var EuiProgress = function EuiProgress(_ref) {
  var className = _ref.className,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? 'secondary' : _ref$color,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      _ref$position = _ref.position,
      position = _ref$position === void 0 ? 'static' : _ref$position,
      max = _ref.max,
      _ref$valueText = _ref.valueText,
      valueText = _ref$valueText === void 0 ? false : _ref$valueText,
      label = _ref.label,
      value = _ref.value,
      labelProps = _ref.labelProps,
      rest = _objectWithoutProperties(_ref, ["className", "color", "size", "position", "max", "valueText", "label", "value", "labelProps"]);

  var determinate = !isNil(max);
  var classes = classNames('euiProgress', {
    'euiProgress--indeterminate': !determinate,
    'euiProgress--native': determinate
  }, sizeToClassNameMap[size], colorToClassNameMap[color], positionsToClassNameMap[position], className);
  var dataClasses = classNames('euiProgress__data', {
    'euiProgress__data--l': size === 'l'
  }, dataColorToClassNameMap[color]);
  var labelClasses = classNames('euiProgress__label', labelProps && labelProps.className);
  var valueRender;

  if (typeof valueText === 'boolean' && valueText) {
    // valueText is a true boolean
    valueRender = React.createElement(EuiI18n, {
      token: "euiProgress.valueText",
      default: "{value}%",
      values: {
        value: value
      }
    });
  } else if (valueText) {
    // valueText exists
    valueRender = valueText;
  } // Because of a Firefox animation issue, indeterminate progress needs to not use <progress />.
  // See https://css-tricks.com/html5-progress-element/


  if (determinate) {
    return React.createElement(Fragment, null, label || valueText ? React.createElement("div", {
      className: dataClasses
    }, label && React.createElement("span", _extends({}, labelProps, {
      className: labelClasses
    }), label), valueRender && React.createElement("span", {
      className: "euiProgress__valueText"
    }, valueRender)) : undefined, React.createElement("progress", _extends({
      className: classes,
      max: max,
      value: value,
      "aria-hidden": label && valueText ? true : false
    }, rest)));
  } else {
    return React.createElement("div", _extends({
      className: classes
    }, rest));
  }
};
EuiProgress.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  size: PropTypes.oneOf(["xs", "s", "m", "l"]),
  color: PropTypes.oneOf(["primary", "secondary", "danger", "subdued", "accent"]),
  position: PropTypes.oneOf(["fixed", "absolute", "static"]),
  max: PropTypes.number,

  /*
       * If true, will render the percentage, otherwise pass a custom node
       */
  valueText: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.node.isRequired]),
  label: PropTypes.node,

  /**
       * Object of props passed to the <span/> wrapping the determinate progress's label
       */
  labelProps: PropTypes.any
};

try {
  EuiProgress.__docgenInfo = {
    description: '',
    displayName: 'EuiProgress',
    methods: [],
    props: {
      max: {
        defaultValue: null,
        description: '',
        name: 'max',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      label: {
        defaultValue: null,
        description: '',
        name: 'label',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      valueText: {
        defaultValue: {
          value: 'false'
        },
        description: '',
        name: 'valueText',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      labelProps: {
        defaultValue: null,
        description: 'Object of props passed to the <span/> wrapping the determinate progress\'s label',
        name: 'labelProps',
        parent: undefined,
        required: false,
        type: {
          name: 'HTMLAttributes<HTMLSpanElement>'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      size: {
        defaultValue: {
          value: 'm'
        },
        description: '',
        name: 'size',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ItemSize',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }]
        }
      },
      color: {
        defaultValue: {
          value: 'secondary'
        },
        description: '',
        name: 'color',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"primary" | "secondary" | "danger" | "accent" | "subdued"',
          value: [{
            value: '"primary"'
          }, {
            value: '"secondary"'
          }, {
            value: '"danger"'
          }, {
            value: '"accent"'
          }, {
            value: '"subdued"'
          }]
        }
      },
      position: {
        defaultValue: {
          value: 'static'
        },
        description: '',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'Positions',
          value: [{
            value: '"static"'
          }, {
            value: '"fixed"'
          }, {
            value: '"absolute"'
          }]
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}