function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback, useRef } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiI18n } from '../i18n';
var sizeToClassNameMap = {
  s: 'euiResizableButton--sizeSmall',
  m: 'euiResizableButton--sizeMedium',
  l: 'euiResizableButton--sizeLarge',
  xl: 'euiResizableButton--sizeExtraLarge'
};
export var SIZES = Object.keys(sizeToClassNameMap);
export var EuiResizableButton = function EuiResizableButton(_ref) {
  var isHorizontal = _ref.isHorizontal,
      className = _ref.className,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      registryRef = _ref.registryRef,
      rest = _objectWithoutProperties(_ref, ["isHorizontal", "className", "size", "registryRef"]);

  var classes = classNames('euiResizableButton', size ? sizeToClassNameMap[size] : null, {
    'euiResizableButton--vertical': !isHorizontal,
    'euiResizableButton--horizontal': isHorizontal
  }, className);
  var previousRef = useRef();
  var onRef = useCallback(function (ref) {
    if (ref) {
      previousRef.current = ref;
      registryRef.current.registerResizerRef(ref);
    } else {
      if (previousRef.current != null) {
        registryRef.current.deregisterResizerRef(previousRef.current);
        previousRef.current = undefined;
      }
    }
  }, [registryRef]);

  var setFocus = function setFocus(e) {
    return e.currentTarget.focus();
  };

  return React.createElement(EuiI18n, {
    tokens: ['euiResizableButton.horizontalResizerAriaLabel', 'euiResizableButton.verticalResizerAriaLabel'],
    defaults: ['Press left or right to adjust panels size', 'Press up or down to adjust panels size']
  }, function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        horizontalResizerAriaLabel = _ref3[0],
        verticalResizerAriaLabel = _ref3[1];

    return React.createElement("button", _extends({
      ref: onRef,
      "aria-label": isHorizontal ? horizontalResizerAriaLabel : verticalResizerAriaLabel,
      className: classes,
      "data-test-subj": "splitPanelResizer",
      type: "button",
      onClick: setFocus
    }, rest));
  });
};
EuiResizableButton.propTypes = {
  /**
     * The size of the Resizer (the space between panels)
     */
  size: PropTypes.oneOf(["s", "m", "l", "xl"]),
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};
export function euiResizableButtonWithControls(controls) {
  return function (props) {
    return React.createElement(EuiResizableButton, _extends({}, controls, props));
  };
}

try {
  euiResizableButtonWithControls.__docgenInfo = {
    description: '',
    displayName: 'euiResizableButtonWithControls',
    methods: [],
    props: {
      onKeyDown: {
        defaultValue: null,
        description: '',
        name: 'onKeyDown',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: true,
        type: {
          name: '(eve: EuiResizableButtonKeyDownEvent) => void'
        }
      },
      onMouseDown: {
        defaultValue: null,
        description: '',
        name: 'onMouseDown',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: true,
        type: {
          name: '(eve: EuiResizableButtonMouseEvent) => void'
        }
      },
      onTouchStart: {
        defaultValue: null,
        description: '',
        name: 'onTouchStart',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: true,
        type: {
          name: '(eve: EuiResizableButtonMouseEvent) => void'
        }
      },
      isHorizontal: {
        defaultValue: null,
        description: '',
        name: 'isHorizontal',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: true,
        type: {
          name: 'boolean'
        }
      },
      registryRef: {
        defaultValue: null,
        description: '',
        name: 'registryRef',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: true,
        type: {
          name: 'any'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiResizableButton.__docgenInfo = {
    description: '',
    displayName: 'EuiResizableButton',
    methods: [],
    props: {
      size: {
        defaultValue: {
          value: 'm'
        },
        description: 'The size of the Resizer (the space between panels)',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l" | "xl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onKeyDown: {
        defaultValue: null,
        description: '',
        name: 'onKeyDown',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: false,
        type: {
          name: '(eve: EuiResizableButtonKeyDownEvent) => void'
        }
      },
      onMouseDown: {
        defaultValue: null,
        description: '',
        name: 'onMouseDown',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: false,
        type: {
          name: '(eve: EuiResizableButtonMouseEvent) => void'
        }
      },
      onTouchStart: {
        defaultValue: null,
        description: '',
        name: 'onTouchStart',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: false,
        type: {
          name: '(eve: EuiResizableButtonMouseEvent) => void'
        }
      },
      isHorizontal: {
        defaultValue: null,
        description: '',
        name: 'isHorizontal',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      registryRef: {
        defaultValue: null,
        description: '',
        name: 'registryRef',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_button.tsx',
          name: 'EuiResizableButtonControls'
        },
        required: false,
        type: {
          name: 'any'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}