function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useRef, useState, useCallback } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { EuiResizablePanelContextProvider, EuiResizablePanelRegistry } from './context';
import { euiResizableButtonWithControls } from './resizable_button';
import { euiResizablePanelWithControls } from './resizable_panel';
import { useContainerCallbacks } from './helpers';
var containerDirections = {
  vertical: 'vertical',
  horizontal: 'horizontal'
};
var initialState = {
  isDragging: false,
  currentResizerPos: -1,
  previousPanelId: null,
  nextPanelId: null,
  resizersSize: 0
};
export var EuiResizableContainer = function EuiResizableContainer(_ref) {
  var _ref$direction = _ref.direction,
      direction = _ref$direction === void 0 ? 'horizontal' : _ref$direction,
      children = _ref.children,
      className = _ref.className,
      onPanelWidthChange = _ref.onPanelWidthChange,
      rest = _objectWithoutProperties(_ref, ["direction", "children", "className", "onPanelWidthChange"]);

  var registryRef = useRef(new EuiResizablePanelRegistry());
  var containerRef = useRef(null);

  var _useState = useState(initialState),
      _useState2 = _slicedToArray(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  var isHorizontal = direction === containerDirections.horizontal;
  var classes = classNames('euiResizableContainer', {
    'euiResizableContainer--vertical': !isHorizontal,
    'euiResizableContainer--horizontal': isHorizontal
  }, className);

  var _useContainerCallback = useContainerCallbacks({
    isHorizontal: isHorizontal,
    state: state,
    setState: setState,
    containerRef: containerRef,
    registryRef: registryRef,
    onPanelWidthChange: onPanelWidthChange
  }),
      onKeyDown = _useContainerCallback.onKeyDown,
      onMouseDown = _useContainerCallback.onMouseDown,
      onMouseMove = _useContainerCallback.onMouseMove;

  var EuiResizableButton = useCallback(euiResizableButtonWithControls({
    onKeyDown: onKeyDown,
    onMouseDown: onMouseDown,
    onTouchStart: onMouseDown,
    isHorizontal: isHorizontal,
    registryRef: registryRef
  }), [onKeyDown, onMouseDown, isHorizontal, registryRef]);
  var EuiResizablePanel = useCallback(euiResizablePanelWithControls({
    isHorizontal: isHorizontal
  }), [isHorizontal]);
  var onMouseUp = useCallback(function () {
    setState(initialState);
  }, []);
  return React.createElement(EuiResizablePanelContextProvider, {
    registry: registryRef.current
  }, React.createElement("div", _extends({
    className: classes,
    ref: containerRef,
    onMouseMove: onMouseMove,
    onMouseUp: onMouseUp,
    onMouseLeave: onMouseUp,
    onTouchMove: onMouseMove,
    onTouchEnd: onMouseUp
  }, rest), children(EuiResizablePanel, EuiResizableButton)));
};
EuiResizableContainer.propTypes = {
  /**
     * Specify the container direction
     */
  direction: PropTypes.oneOf(["vertical", "horizontal"]),

  /**
     * Pure function which accepts Panel and Resizer components in arguments
     * and returns a component tree
     */
  children: PropTypes.func.isRequired,

  /**
     * Pure function which accepts an object where keys are IDs of panels, which sizes were changed,
     * and values are actual sizes in percents
     */
  onPanelWidthChange: PropTypes.func,
  style: PropTypes.any,
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string
};

try {
  EuiResizableContainer.__docgenInfo = {
    description: '',
    displayName: 'EuiResizableContainer',
    methods: [],
    props: {
      direction: {
        defaultValue: {
          value: 'horizontal'
        },
        description: 'Specify the container direction',
        name: 'direction',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"horizontal" | "vertical"',
          value: [{
            value: '"horizontal"'
          }, {
            value: '"vertical"'
          }]
        }
      },
      children: {
        defaultValue: null,
        description: 'Pure function which accepts Panel and Resizer components in arguments\nand returns a component tree',
        name: 'children',
        parent: undefined,
        required: true,
        type: {
          name: '(Panel: ComponentType<EuiResizablePanelProps>, Resizer: ComponentType<EuiResizableButtonProps>) => ReactNode'
        }
      },
      onPanelWidthChange: {
        defaultValue: null,
        description: 'Pure function which accepts an object where keys are IDs of panels, which sizes were changed,\nand values are actual sizes in percents',
        name: 'onPanelWidthChange',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: '({}: { [key: string]: number; }) => any'
        }
      },
      style: {
        defaultValue: null,
        description: '',
        name: 'style',
        parent: {
          fileName: 'eui/src/components/resizable_container/resizable_container.tsx',
          name: 'EuiResizableContainerProps'
        },
        required: false,
        type: {
          name: 'CSSProperties'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}