/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
var responsiveSizesToClassNameMap = {
  xs: 'eui-hideFor--xs',
  s: 'eui-hideFor--s',
  m: 'eui-hideFor--m',
  l: 'eui-hideFor--l',
  xl: 'eui-hideFor--xl'
};
export var EuiHideFor = function EuiHideFor(_ref) {
  var children = _ref.children,
      sizes = _ref.sizes;
  var utilityClasses = sizes.map(function (item) {
    return responsiveSizesToClassNameMap[item];
  });

  if (React.isValidElement(children)) {
    return React.createElement(React.Fragment, null, React.Children.map(children, function (child) {
      return React.cloneElement(child, {
        className: classNames(child.props.className, utilityClasses)
      });
    }));
  } else {
    return React.createElement("span", {
      className: classNames(utilityClasses)
    }, children);
  }
};
EuiHideFor.propTypes = {
  children: PropTypes.node,

  /**
     * List of all the responsive sizes to show the children for.
     * Options are `'xs' | 's' | 'm' | 'l' | 'xl'`
     */
  sizes: PropTypes.arrayOf(PropTypes.oneOf(["xs", "s", "m", "l", "xl"]).isRequired).isRequired
};

try {
  EuiHideFor.__docgenInfo = {
    description: '',
    displayName: 'EuiHideFor',
    methods: [],
    props: {
      sizes: {
        defaultValue: null,
        description: 'List of all the responsive sizes to show the children for.\nOptions are `\'xs\' | \'s\' | \'m\' | \'l\' | \'xl\'`',
        name: 'sizes',
        parent: {
          fileName: 'eui/src/components/responsive/hide_for.tsx',
          name: 'EuiHideForProps'
        },
        required: true,
        type: {
          name: 'EuiBreakpointSize[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}