/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiHideFor } from './hide_for';
export { EuiShowFor } from './show_for';

try {
  EuiHideFor.__docgenInfo = {
    description: '',
    displayName: 'EuiHideFor',
    methods: [],
    props: {
      sizes: {
        defaultValue: null,
        description: 'List of all the responsive sizes to show the children for.\nOptions are `\'xs\' | \'s\' | \'m\' | \'l\' | \'xl\'`',
        name: 'sizes',
        parent: {
          fileName: 'eui/src/components/responsive/hide_for.tsx',
          name: 'EuiHideForProps'
        },
        required: true,
        type: {
          name: 'EuiBreakpointSize[]'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiShowFor.__docgenInfo = {
    description: '',
    displayName: 'EuiShowFor',
    methods: [],
    props: {
      sizes: {
        defaultValue: null,
        description: 'List of all the responsive sizes to show the children for.\nOptions are `\'xs\' | \'s\' | \'m\' | \'l\' | \'xl\'`',
        name: 'sizes',
        parent: {
          fileName: 'eui/src/components/responsive/show_for.tsx',
          name: 'EuiShowForProps'
        },
        required: true,
        type: {
          name: 'EuiBreakpointSize[]'
        }
      },
      display: {
        defaultValue: null,
        description: 'Optional display as property. Leaving as `undefined` renders as `inline`.',
        name: 'display',
        parent: {
          fileName: 'eui/src/components/responsive/show_for.tsx',
          name: 'EuiShowForProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiShowForDisplay',
          value: [{
            value: '"inlineBlock"'
          }, {
            value: '"block"'
          }, {
            value: '"flex"'
          }]
        }
      }
    },
    extends: []
  };
} catch (e) {}