/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiSelectable } from './selectable';
export { EuiSelectableList, EuiSelectableListItem } from './selectable_list';
export { EuiSelectableMessage } from './selectable_message';
export {} from './selectable_option';
export { EuiSelectableSearch } from './selectable_search';
export { EuiSelectableTemplateSitewide } from './selectable_templates';

try {
  EuiSelectable.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectable',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      searchable: {
        defaultValue: null,
        description: 'Hooks up a search box to filter the list (boolean)',
        name: 'searchable',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      searchProps: {
        defaultValue: null,
        description: 'Passes props down to the `EuiFieldSearch`',
        name: 'searchProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<EuiSelectableSearchProps>'
        }
      },
      children: {
        defaultValue: null,
        description: 'Function that takes the `list` node and then\nthe `search` node (if `searchable` is applied)',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: '((list: ReactElement<any, string | ((props: any) => ReactElement<any, string | ... | (new (props: any) => Component<any, any, any>)>) | (new (props: any) => Component<any, any, any>)>, search: ReactElement<...>) => ReactNode) | ... 6 more ... | (((list: ReactElement<...>, search: ReactElement<...>) => ReactNode) & R...'
        }
      },
      options: {
        defaultValue: null,
        description: 'Array of EuiSelectableOption objects. See #EuiSelectableOptionProps',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: '((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Passes back the altered `options` array with selected options as',
        name: 'onChange',
        parent: undefined,
        required: false,
        type: {
          name: '(options: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]) => void'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: 'Sets the single selection policy of\n`false`: allows multiple selection\n`true`: only allows one selection\n`always`: can and must have only one selection',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | "always"'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: 'Allows marking options as `checked=\'off\'` as well as `\'on\'`',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Show an loading indicator while you load and hook up your data',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      height: {
        defaultValue: null,
        description: 'Sets the max height in pixels or pass `full` to allow\nthe whole group to fill the height of its container and\nallows the list grow as well',
        name: 'height',
        parent: undefined,
        required: false,
        type: {
          name: 'number | "full"'
        }
      },
      listProps: {
        defaultValue: null,
        description: 'See #EuiSelectableOptionsList',
        name: 'listProps',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSelectableOptionsListPropsWithDefaults'
        }
      },
      renderOption: {
        defaultValue: null,
        description: 'Custom render function for each option.\nReturns `(option, searchValue)`',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: (DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }), searchValue: string) => ReactNode'
        }
      },
      loadingMessage: {
        defaultValue: null,
        description: 'Customize the loading message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'loadingMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      noMatchesMessage: {
        defaultValue: null,
        description: 'Customize the no matches message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'noMatchesMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      emptyMessage: {
        defaultValue: null,
        description: 'Customize the empty message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'emptyMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSelectableList.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableList',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      activeOptionIndex: {
        defaultValue: null,
        description: 'The index of the option to be highlighted as pseudo-focused;\nGood for use when only one selection is allowed and needing to open\ndirectly to that option',
        name: 'activeOptionIndex',
        parent: undefined,
        required: false,
        type: {
          name: 'number'
        }
      },
      rowHeight: {
        defaultValue: null,
        description: 'The height of each option in pixels. Defaults to `32`',
        name: 'rowHeight',
        parent: undefined,
        required: true,
        type: {
          name: 'number'
        }
      },
      showIcons: {
        defaultValue: null,
        description: 'Show the check/cross selection indicator icons',
        name: 'showIcons',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: '',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | "always"'
        }
      },
      windowProps: {
        defaultValue: null,
        description: 'Any props to send specifically to the react-window `FixedSizeList`',
        name: 'windowProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<ListProps>'
        }
      },
      bordered: {
        defaultValue: null,
        description: 'Adds a border around the list to indicate the bounds;\nUseful when the list scrolls, otherwise use your own container',
        name: 'bordered',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onFocusBadge: {
        defaultValue: null,
        description: 'When enabled by setting to either `true` or passing custom text,\nshows a hollow badge as an append (far right) when the item is focused.\nThe default content when `true` is `↩ to select/deselect/include/exclude`',
        name: 'onFocusBadge',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | ({ iconType?: IconType; iconSide?: ButtonContentIconSide; color?: string; isDisabled?: boolean; closeButtonProps?: Partial<EuiIconProps>; } & CommonProps & DisambiguateSet<...> & DisambiguateSet<...> & Pick<...>) | ... 4 more ... | ({ ...; } & ... 6 more ... & Pick<...>)'
        }
      },
      options: {
        defaultValue: null,
        description: 'All possible options',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: '((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]'
        }
      },
      visibleOptions: {
        defaultValue: null,
        description: 'Filtered options list (if applicable)',
        name: 'visibleOptions',
        parent: undefined,
        required: false,
        type: {
          name: '((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]'
        }
      },
      searchValue: {
        defaultValue: null,
        description: 'Search value to highlight on the option render',
        name: 'searchValue',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      onOptionClick: {
        defaultValue: null,
        description: 'Returns the array of options with altered checked state',
        name: 'onOptionClick',
        parent: undefined,
        required: true,
        type: {
          name: '(options: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]) => void'
        }
      },
      renderOption: {
        defaultValue: null,
        description: 'Custom render for the label portion of the option;\nTakes (option, searchValue), returns ReactNode',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: (DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }), searchValue: string) => ReactNode'
        }
      },
      height: {
        defaultValue: null,
        description: 'Sets the max height in pixels or pass `full` to allow\nthe whole group to fill the height of its container and\nallows the list grow as well',
        name: 'height',
        parent: undefined,
        required: false,
        type: {
          name: 'number | "full"'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: 'Allow cycling through the on, off and undefined state of option.checked\nand not just on and undefined',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      searchable: {
        defaultValue: null,
        description: '',
        name: 'searchable',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      makeOptionId: {
        defaultValue: null,
        description: '',
        name: 'makeOptionId',
        parent: undefined,
        required: true,
        type: {
          name: '(index: number) => string'
        }
      },
      listId: {
        defaultValue: null,
        description: '',
        name: 'listId',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      setActiveOptionIndex: {
        defaultValue: null,
        description: '',
        name: 'setActiveOptionIndex',
        parent: undefined,
        required: true,
        type: {
          name: '(index: number, cb?: () => void) => void'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSelectableListItem.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableListItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'HTMLAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/node_modules/@types/react/index.d.ts',
          name: 'AriaAttributes'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      checked: {
        defaultValue: null,
        description: 'Applies an icon and visual styling to activated items',
        name: 'checked',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"on" | "off"',
          value: [{
            value: '"on"'
          }, {
            value: '"off"'
          }]
        }
      },
      showIcons: {
        defaultValue: null,
        description: 'Shows icons based on `checked` type',
        name: 'showIcons',
        parent: undefined,
        required: true,
        type: {
          name: 'boolean'
        }
      },
      isFocused: {
        defaultValue: null,
        description: 'Highlights the item for pseudo focus',
        name: 'isFocused',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      disabled: {
        defaultValue: null,
        description: '',
        name: 'disabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      prepend: {
        defaultValue: null,
        description: '',
        name: 'prepend',
        parent: undefined,
        required: false,
        type: {
          name: 'any'
        }
      },
      append: {
        defaultValue: null,
        description: '',
        name: 'append',
        parent: undefined,
        required: false,
        type: {
          name: 'any'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: '',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onFocusBadge: {
        defaultValue: null,
        description: 'When enabled by setting to either `true` or passing custom a custom badge,\nshows a hollow badge as an append (far right) when the item is focused.\nThe default content when `true` is `↩ to select/deselect/include/exclude`',
        name: 'onFocusBadge',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | ({ iconType?: IconType; iconSide?: ButtonContentIconSide; color?: string; isDisabled?: boolean; closeButtonProps?: Partial<EuiIconProps>; } & CommonProps & DisambiguateSet<...> & DisambiguateSet<...> & Pick<...>) | ... 4 more ... | ({ ...; } & ... 6 more ... & Pick<...>)'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSelectableSearch.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableSearch',
    methods: [],
    props: {
      fullWidth: {
        defaultValue: null,
        description: '',
        name: 'fullWidth',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isLoading: {
        defaultValue: null,
        description: '',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      id: {
        defaultValue: null,
        description: '',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      placeholder: {
        defaultValue: null,
        description: '',
        name: 'placeholder',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      compressed: {
        defaultValue: null,
        description: 'when `true` creates a shorter height input',
        name: 'compressed',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      inputRef: {
        defaultValue: null,
        description: '',
        name: 'inputRef',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: '(node: HTMLInputElement) => void'
        }
      },
      isInvalid: {
        defaultValue: null,
        description: '',
        name: 'isInvalid',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      prepend: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming before input\n`string` | `ReactElement` or an array of these',
        name: 'prepend',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      append: {
        defaultValue: null,
        description: 'Creates an input group with element(s) coming after input.\n`string` | `ReactElement` or an array of these',
        name: 'append',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'PrependAppendType'
        }
      },
      isClearable: {
        defaultValue: null,
        description: 'Shows a button that quickly clears any input',
        name: 'isClearable',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onSearch: {
        defaultValue: null,
        description: 'Called when the user presses [Enter] OR on change if the incremental prop is `true`.\nIf you don\'t need the on[Enter] functionality, prefer using onChange',
        name: 'onSearch',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: '(value: string) => void'
        }
      },
      incremental: {
        defaultValue: null,
        description: 'When `true` the search will be executed (that is, the `onSearch` will be called) as the\nuser types.',
        name: 'incremental',
        parent: {
          fileName: 'eui/src/components/form/field_search/field_search.tsx',
          name: 'EuiFieldSearchProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Passes back (matchingOptions, searchValue)',
        name: 'onChange',
        parent: undefined,
        required: true,
        type: {
          name: '(matchingOptions: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[], searchValue: string) => void'
        }
      },
      options: {
        defaultValue: null,
        description: '',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: '((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]'
        }
      },
      listId: {
        defaultValue: null,
        description: 'The id of the visible list to create the appropriate aria controls',
        name: 'listId',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiSelectableTemplateSitewide.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableTemplateSitewide',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'Function that takes the `list` node and then\nthe `search` node (if `searchable` is applied)',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: '(list: ReactElement, search: ReactElement<...>) => ReactNode'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Show an loading indicator while you load and hook up your data',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Passes back the altered `options` array with selected options as',
        name: 'onChange',
        parent: undefined,
        required: false,
        type: {
          name: '(options: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]) => void'
        }
      },
      height: {
        defaultValue: null,
        description: 'Sets the max height in pixels or pass `full` to allow\nthe whole group to fill the height of its container and\nallows the list grow as well',
        name: 'height',
        parent: undefined,
        required: false,
        type: {
          name: 'number | "full"'
        }
      },
      renderOption: {
        defaultValue: null,
        description: 'Custom render function for each option.\nReturns `(option, searchValue)`',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: (DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }), searchValue: string) => ReactNode'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: 'Sets the single selection policy of\n`false`: allows multiple selection\n`true`: only allows one selection\n`always`: can and must have only one selection',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | "always"'
        }
      },
      searchable: {
        defaultValue: null,
        description: 'Hooks up a search box to filter the list (boolean)',
        name: 'searchable',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      searchProps: {
        defaultValue: null,
        description: 'Passes props down to the `EuiFieldSearch`',
        name: 'searchProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<EuiSelectableSearchProps>'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: 'Allows marking options as `checked=\'off\'` as well as `\'on\'`',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      listProps: {
        defaultValue: null,
        description: 'See #EuiSelectableOptionsList',
        name: 'listProps',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSelectableOptionsListPropsWithDefaults'
        }
      },
      loadingMessage: {
        defaultValue: null,
        description: 'Customize the loading message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'loadingMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      noMatchesMessage: {
        defaultValue: null,
        description: 'Customize the no matches message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'noMatchesMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      emptyMessage: {
        defaultValue: null,
        description: 'Customize the empty message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'emptyMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      options: {
        defaultValue: null,
        description: 'Extends the typical EuiSelectable #Options with the addition of pre-composed elements\nsuch as `icon`, `avatar`and `meta`',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiSelectableTemplateSitewideOption<{ [key: string]: any; }>[]'
        }
      },
      popoverProps: {
        defaultValue: null,
        description: 'Override some of the EuiPopover props housing the list.\nThe default width is `600`',
        name: 'popoverProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<Props> & { width?: ReactText; }'
        }
      },
      popoverTitle: {
        defaultValue: null,
        description: 'Optionally provide a title for the popover',
        name: 'popoverTitle',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      popoverFooter: {
        defaultValue: null,
        description: 'Optionally provide a footer for the popover',
        name: 'popoverFooter',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}