function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { useCombinedRefs } from '../../../services';
import { EuiSelectable } from '../selectable';
import { EuiPopoverTitle, EuiPopoverFooter } from '../../popover';
import { EuiPopover } from '../../popover/popover';
import { useEuiI18n, EuiI18n } from '../../i18n';
import { EuiSelectableMessage } from '../selectable_message';
import { EuiLoadingSpinner } from '../../loading';
import { euiSelectableTemplateSitewideFormatOptions, euiSelectableTemplateSitewideRenderOptions } from './selectable_template_sitewide_option';
export var EuiSelectableTemplateSitewide = function EuiSelectableTemplateSitewide(_ref) {
  var children = _ref.children,
      className = _ref.className,
      options = _ref.options,
      popoverProps = _ref.popoverProps,
      popoverTitle = _ref.popoverTitle,
      popoverFooter = _ref.popoverFooter,
      searchProps = _ref.searchProps,
      listProps = _ref.listProps,
      isLoading = _ref.isLoading,
      rest = _objectWithoutProperties(_ref, ["children", "className", "options", "popoverProps", "popoverTitle", "popoverFooter", "searchProps", "listProps", "isLoading"]);

  /**
   * i18n text
   */
  var _useEuiI18n = useEuiI18n(['euiSelectableTemplateSitewide.searchPlaceholder'], ['Search for anything...']),
      _useEuiI18n2 = _slicedToArray(_useEuiI18n, 1),
      searchPlaceholder = _useEuiI18n2[0];
  /**
   * Internal states
   */


  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      inputHasFocus = _useState2[0],
      setInputHasFocus = _useState2[1];
  /**
   * Popover helpers
   */


  var _useState3 = useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      popoverRef = _useState4[0],
      setPopoverRef = _useState4[1];

  var _popoverProps = _objectSpread({}, popoverProps),
      _closePopover = _popoverProps.closePopover,
      panelRef = _popoverProps.panelRef,
      width = _popoverProps.width,
      popoverRest = _objectWithoutProperties(_popoverProps, ["closePopover", "panelRef", "width"]);

  var closePopover = function closePopover() {
    setInputHasFocus(false);
    _closePopover && _closePopover();
  }; // Width applied to the internal div


  var popoverWidth = width || 600;
  var setPanelRef = useCombinedRefs([setPopoverRef, panelRef]);
  /**
   * Search helpers
   */

  var searchOnFocus = function searchOnFocus(e) {
    searchProps && searchProps.onFocus && searchProps.onFocus(e);
    setInputHasFocus(true);
  };

  var onSearchInput = function onSearchInput(e) {
    searchProps && searchProps.onInput && searchProps.onInput(e);
    setInputHasFocus(true);
  };

  var searchOnBlur = function searchOnBlur(e) {
    searchProps && searchProps.onBlur && searchProps.onBlur(e);

    if (!(popoverRef === null || popoverRef === void 0 ? void 0 : popoverRef.contains(e.relatedTarget))) {
      setInputHasFocus(false);
    }
  };
  /**
   * Classes
   */


  var classes = classNames('euiSelectableTemplateSitewide', className);
  var searchClasses = classNames('euiSelectableTemplateSitewide__search', searchProps && searchProps.className);
  var listClasses = classNames('euiSelectableTemplateSitewide__list', listProps && listProps.className);
  /**
   * List options
   */

  var formattedOptions = euiSelectableTemplateSitewideFormatOptions(options);
  var loadingMessage = React.createElement(EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, React.createElement(EuiLoadingSpinner, {
    size: "l"
  }), React.createElement("br", null), React.createElement("p", null, React.createElement(EuiI18n, {
    token: "euiSelectableTemplateSitewide.loadingResults",
    default: "Loading results"
  })));
  var emptyMessage = React.createElement(EuiSelectableMessage, {
    style: {
      minHeight: 300
    }
  }, React.createElement("p", null, React.createElement(EuiI18n, {
    token: "euiSelectableTemplateSitewide.noResults",
    default: "No results available"
  })));
  return React.createElement(EuiSelectable, _extends({
    isLoading: isLoading,
    options: formattedOptions,
    renderOption: euiSelectableTemplateSitewideRenderOptions,
    singleSelection: true,
    searchProps: _objectSpread({
      placeholder: searchPlaceholder,
      isClearable: true
    }, searchProps, {
      onFocus: searchOnFocus,
      onBlur: searchOnBlur,
      onInput: onSearchInput,
      className: searchClasses
    }),
    listProps: _objectSpread({
      rowHeight: 68,
      showIcons: false,
      onFocusBadge: {
        iconSide: 'right',
        children: React.createElement(EuiI18n, {
          token: "euiSelectableTemplateSitewide.onFocusBadgeGoTo",
          default: "Go to"
        })
      }
    }, listProps, {
      className: listClasses
    }),
    loadingMessage: loadingMessage,
    emptyMessage: emptyMessage,
    noMatchesMessage: emptyMessage
  }, rest, {
    className: classes,
    searchable: true
  }), function (list, search) {
    return React.createElement(EuiPopover, _extends({
      panelPaddingSize: "none",
      display: "block",
      isOpen: inputHasFocus
    }, popoverRest, {
      panelRef: setPanelRef,
      button: search,
      closePopover: closePopover
    }), React.createElement("div", {
      style: {
        width: popoverWidth,
        maxWidth: '100%'
      }
    }, popoverTitle && React.createElement(EuiPopoverTitle, null, popoverTitle), list, popoverFooter && React.createElement(EuiPopoverFooter, null, popoverFooter)));
  });
};
EuiSelectableTemplateSitewide.propTypes = {
  /**
     * Extends the typical EuiSelectable #Options with the addition of pre-composed elements
     * such as `icon`, `avatar`and `meta`
     */
  options: PropTypes.arrayOf(PropTypes.shape({
    /**
       * Displayed on the left (`prepend`).
       * Object of `EuiIconProps` for display of the solution/application's logo
       */
    icon: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,

      /**
           * One of EUI's color palette or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value.
           * Note that coloring only works if your SVG is removed of fill attributes.
           */
      color: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.oneOf(["default", "primary", "secondary", "success", "accent", "warning", "danger", "text", "subdued", "ghost"]).isRequired]),

      /**
           * Descriptive title for naming the icon based on its use
           */
      title: PropTypes.string,

      /**
           * A unique identifier for the title element
           */
      titleId: PropTypes.string,

      /**
           * Its value should be one or more element IDs
           */
      "aria-labelledby": PropTypes.string,

      /**
           * Callback when the icon has been loaded & rendered
           */
      onIconLoad: PropTypes.func
    }),

    /**
       * Displayed on the right (`append`).
       * Object of `EuiAvatarProps` for display of the space (default) or user
       */
    avatar: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,

      /**
           * Full name of avatar for title attribute and calculating initial if not provided
           */
      name: PropTypes.string.isRequired,

      /**
           * Accepts hex value `#FFFFFF`, `#000` otherwise a viz palette color will be assigned
           */
      color: PropTypes.string,

      /**
           * Custom initials (max 2 characters).
           * By default will take the first character (of each word).
           */
      initials: PropTypes.string,

      /**
           * Specify how many characters to show (max 2 allowed).
           * By default, will show based on number of words.
           */
      initialsLength: PropTypes.oneOf([1, 2]),

      /**
           * The type of avatar this is displaying
           */
      type: PropTypes.oneOf(["space", "user"]),
      imageUrl: PropTypes.string,
      size: PropTypes.oneOf(["none", "s", "m", "l", "xl"])
    }),

    /**
       * An array of inline #MetaData displayed beneath the label and separated by bullets.
       */
    meta: PropTypes.arrayOf(PropTypes.shape({
      /**
         * Required to display the metadata
         */
      text: PropTypes.string.isRequired,

      /**
         * Styles the metadata according to Elastic's schema.
         * Can be one of 'application', 'deployment', 'article', 'case', 'platform',
         * or a custom string to associate with your own schema.
         * Appends the string to the class name as `euiSelectableTemplateSitewide__optionMeta--[type]`
         */
      type: PropTypes.oneOfType([PropTypes.oneOf(["application", "deployment", "article", "case", "platform"]), PropTypes.string.isRequired]),

      /**
         * Will wrap the meta tag in EuiHighlight to mark the portions that match the search text
         */
      highlightSearchString: PropTypes.bool,
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string
    }).isRequired),

    /**
       * Optional `boolean`.
       * Set to `true` to indicate object is just a grouping label, not a selectable item
       */
    isGroupLabel: PropTypes.oneOfType([PropTypes.oneOf([true]).isRequired, PropTypes.oneOf([false])]),
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Visible label of option.
       * Must be unique across items if `key` is not supplied
       */
    label: PropTypes.string,

    /**
       * Optionally change the searchable term by passing a different string other than the `label`.
       * Best used when creating a custom `optionRender` to separate the label from metadata but allowing to search on both
       */
    searchableLabel: PropTypes.string,

    /**
       * Must be unique across items.
       * Will be used to match options instead of `label`
       */
    key: PropTypes.string,

    /**
       * Leave `undefined` to indicate not selected,
       * 'on' to indicate inclusion and
       * 'off' to indicate exclusion
       */
    checked: PropTypes.oneOf(["on", "off", undefined]),
    disabled: PropTypes.bool,

    /**
       * Node to add between the selection icon and the label
       */
    prepend: PropTypes.node,

    /**
       * Node to add to the far right of the item
       */
    append: PropTypes.node,
    ref: PropTypes.func
  }).isRequired).isRequired,

  /**
     * Override some of the EuiPopover props housing the list.
     * The default width is `600`
     */
  popoverProps: PropTypes.shape({
    width: PropTypes.any
  }),

  /**
     * Optionally provide a title for the popover
     */
  popoverTitle: PropTypes.node,

  /**
     * Optionally provide a footer for the popover
     */
  popoverFooter: PropTypes.node
};

try {
  EuiSelectableTemplateSitewide.__docgenInfo = {
    description: '',
    displayName: 'EuiSelectableTemplateSitewide',
    methods: [],
    props: {
      children: {
        defaultValue: null,
        description: 'Function that takes the `list` node and then\nthe `search` node (if `searchable` is applied)',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: '(list: ReactElement, search: ReactElement<...>) => ReactNode'
        }
      },
      isLoading: {
        defaultValue: null,
        description: 'Show an loading indicator while you load and hook up your data',
        name: 'isLoading',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'Passes back the altered `options` array with selected options as',
        name: 'onChange',
        parent: undefined,
        required: false,
        type: {
          name: '(options: ((DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }))[]) => void'
        }
      },
      height: {
        defaultValue: null,
        description: 'Sets the max height in pixels or pass `full` to allow\nthe whole group to fill the height of its container and\nallows the list grow as well',
        name: 'height',
        parent: undefined,
        required: false,
        type: {
          name: 'number | "full"'
        }
      },
      renderOption: {
        defaultValue: null,
        description: 'Custom render function for each option.\nReturns `(option, searchValue)`',
        name: 'renderOption',
        parent: undefined,
        required: false,
        type: {
          name: '(option: (DisambiguateSet<EuiSelectableGroupLabelOption<{}>, EuiSelectableLIOption<{}>> & CommonProps & { ...; } & HTMLAttributes<...>) | (DisambiguateSet<...> & ... 2 more ... & { ...; }), searchValue: string) => ReactNode'
        }
      },
      singleSelection: {
        defaultValue: null,
        description: 'Sets the single selection policy of\n`false`: allows multiple selection\n`true`: only allows one selection\n`always`: can and must have only one selection',
        name: 'singleSelection',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean | "always"'
        }
      },
      searchable: {
        defaultValue: null,
        description: 'Hooks up a search box to filter the list (boolean)',
        name: 'searchable',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      searchProps: {
        defaultValue: null,
        description: 'Passes props down to the `EuiFieldSearch`',
        name: 'searchProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<EuiSelectableSearchProps>'
        }
      },
      allowExclusions: {
        defaultValue: null,
        description: 'Allows marking options as `checked=\'off\'` as well as `\'on\'`',
        name: 'allowExclusions',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      listProps: {
        defaultValue: null,
        description: 'See #EuiSelectableOptionsList',
        name: 'listProps',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSelectableOptionsListPropsWithDefaults'
        }
      },
      loadingMessage: {
        defaultValue: null,
        description: 'Customize the loading message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'loadingMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      noMatchesMessage: {
        defaultValue: null,
        description: 'Customize the no matches message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'noMatchesMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      emptyMessage: {
        defaultValue: null,
        description: 'Customize the empty message. Pass a string to simply change the text,\nor a node to replace the whole content.',
        name: 'emptyMessage',
        parent: undefined,
        required: false,
        type: {
          name: 'string | ReactElement'
        }
      },
      options: {
        defaultValue: null,
        description: 'Extends the typical EuiSelectable #Options with the addition of pre-composed elements\nsuch as `icon`, `avatar`and `meta`',
        name: 'options',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiSelectableTemplateSitewideOption<{ [key: string]: any; }>[]'
        }
      },
      popoverProps: {
        defaultValue: null,
        description: 'Override some of the EuiPopover props housing the list.\nThe default width is `600`',
        name: 'popoverProps',
        parent: undefined,
        required: false,
        type: {
          name: 'Partial<Props> & { width?: ReactText; }'
        }
      },
      popoverTitle: {
        defaultValue: null,
        description: 'Optionally provide a title for the popover',
        name: 'popoverTitle',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      popoverFooter: {
        defaultValue: null,
        description: 'Optionally provide a footer for the popover',
        name: 'popoverFooter',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactNode'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}