/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiSideNav } from './side_nav';
export * from './side_nav_types';

try {
  EuiSideNav.__docgenInfo = {
    description: '',
    displayName: 'EuiSideNav',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: 'Class names to be merged into the final `className` property.',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'EuiSideNavProps<T>["className"]'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'EuiSideNavProps<T>["aria-label"]'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'EuiSideNavProps<T>["data-test-subj"]'
        }
      },
      children: {
        defaultValue: null,
        description: '`children` are not rendered. Use `items` to specify navigation items instead.',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'never'
        }
      },
      toggleOpenOnMobile: {
        defaultValue: null,
        description: 'When called, toggles visibility of the navigation menu at mobile responsive widths. The callback should set the `isOpenOnMobile` prop to actually toggle navigation visibility.',
        name: 'toggleOpenOnMobile',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSideNavProps<T>["toggleOpenOnMobile"]'
        }
      },
      isOpenOnMobile: {
        defaultValue: null,
        description: 'If `true`, the navigation menu will be open at mobile device widths. Use in conjunction with the `toggleOpenOnMobile` prop.',
        name: 'isOpenOnMobile',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSideNavProps<T>["isOpenOnMobile"]'
        }
      },
      mobileTitle: {
        defaultValue: null,
        description: 'A React node to render at mobile responsive widths, representing the title of this navigation menu.',
        name: 'mobileTitle',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSideNavProps<T>["mobileTitle"]'
        }
      },
      items: {
        defaultValue: null,
        description: 'An array of #EuiSideNavItem objects. Lists navigation menu items.',
        name: 'items',
        parent: undefined,
        required: true,
        type: {
          name: 'EuiSideNavProps<T>["items"]'
        }
      },
      renderItem: {
        defaultValue: null,
        description: 'Overrides default navigation menu item rendering. When called, it should return a React node representing a replacement navigation item.',
        name: 'renderItem',
        parent: undefined,
        required: false,
        type: {
          name: 'EuiSideNavProps<T>["renderItem"]'
        }
      }
    },
    extends: []
  };
} catch (e) {}