function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { cloneElement } from 'react';
import classNames from 'classnames';
import { EuiIcon } from '../icon';
import { getSecureRelForTarget } from '../../services';

var DefaultRenderItem = function DefaultRenderItem(_ref) {
  var href = _ref.href,
      target = _ref.target,
      rel = _ref.rel,
      onClick = _ref.onClick,
      className = _ref.className,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, ["href", "target", "rel", "onClick", "className", "children"]);

  if (href) {
    var secureRel = getSecureRelForTarget({
      href: href,
      rel: rel,
      target: target
    });
    return React.createElement("a", _extends({
      className: className,
      href: href,
      target: target,
      rel: secureRel,
      onClick: onClick
    }, rest), children);
  }

  if (onClick) {
    return React.createElement("button", _extends({
      type: "button",
      className: className,
      onClick: onClick
    }, rest), children);
  }

  return React.createElement("div", _extends({
    className: className
  }, rest), children);
};

export function EuiSideNavItem(_ref2) {
  var isOpen = _ref2.isOpen,
      isSelected = _ref2.isSelected,
      isParent = _ref2.isParent,
      icon = _ref2.icon,
      onClick = _ref2.onClick,
      href = _ref2.href,
      rel = _ref2.rel,
      target = _ref2.target,
      items = _ref2.items,
      children = _ref2.children,
      _ref2$renderItem = _ref2.renderItem,
      RenderItem = _ref2$renderItem === void 0 ? DefaultRenderItem : _ref2$renderItem,
      _ref2$depth = _ref2.depth,
      depth = _ref2$depth === void 0 ? 0 : _ref2$depth,
      className = _ref2.className,
      rest = _objectWithoutProperties(_ref2, ["isOpen", "isSelected", "isParent", "icon", "onClick", "href", "rel", "target", "items", "children", "renderItem", "depth", "className"]);

  var childItems;

  if (items && isOpen) {
    childItems = React.createElement("div", {
      className: "euiSideNavItem__items"
    }, items);
  }

  var buttonIcon;

  if (icon) {
    buttonIcon = cloneElement(icon, {
      className: classNames('euiSideNavItemButton__icon', icon.props.className)
    });
  }

  var classes = classNames('euiSideNavItem', {
    'euiSideNavItem--root': depth === 0,
    'euiSideNavItem--rootIcon': depth === 0 && icon,
    'euiSideNavItem--trunk': depth === 1,
    'euiSideNavItem--branch': depth > 1,
    'euiSideNavItem--hasChildItems': !!childItems
  }, className);
  var buttonClasses = classNames('euiSideNavItemButton', {
    'euiSideNavItemButton--isClickable': onClick || href,
    'euiSideNavItemButton-isOpen': depth > 0 && isOpen && !isSelected,
    'euiSideNavItemButton-isSelected': isSelected
  });
  var caret;

  if (depth > 0 && isParent && !isOpen && !isSelected) {
    caret = React.createElement(EuiIcon, {
      type: "arrowDown",
      color: "subdued",
      size: "s"
    });
  }

  var buttonContent = React.createElement("span", {
    className: "euiSideNavItemButton__content"
  }, buttonIcon, React.createElement("span", {
    className: "euiSideNavItemButton__label"
  }, children), caret);
  var renderItemProps = {
    href: href,
    rel: rel,
    target: target,
    onClick: onClick,
    className: buttonClasses,
    children: buttonContent
  };
  return React.createElement("div", {
    className: classes
  }, React.createElement(RenderItem, _extends({}, renderItemProps, rest)), childItems);
}

try {
  EuiSideNavItem.__docgenInfo = {
    description: '',
    displayName: 'EuiSideNavItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      onClick: {
        defaultValue: null,
        description: '',
        name: 'onClick',
        parent: undefined,
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLElement | HTMLButtonElement, MouseEvent>) => void'
        }
      },
      isOpen: {
        defaultValue: null,
        description: '',
        name: 'isOpen',
        parent: {
          fileName: 'eui/src/components/side_nav/side_nav_item.tsx',
          name: 'SideNavItemProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelected: {
        defaultValue: null,
        description: '',
        name: 'isSelected',
        parent: {
          fileName: 'eui/src/components/side_nav/side_nav_item.tsx',
          name: 'SideNavItemProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isParent: {
        defaultValue: null,
        description: '',
        name: 'isParent',
        parent: {
          fileName: 'eui/src/components/side_nav/side_nav_item.tsx',
          name: 'SideNavItemProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      icon: {
        defaultValue: null,
        description: '',
        name: 'icon',
        parent: {
          fileName: 'eui/src/components/side_nav/side_nav_item.tsx',
          name: 'SideNavItemProps'
        },
        required: false,
        type: {
          name: 'ReactElement'
        }
      },
      items: {
        defaultValue: null,
        description: '',
        name: 'items',
        parent: {
          fileName: 'eui/src/components/side_nav/side_nav_item.tsx',
          name: 'SideNavItemProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      depth: {
        defaultValue: {
          value: '0'
        },
        description: '',
        name: 'depth',
        parent: {
          fileName: 'eui/src/components/side_nav/side_nav_item.tsx',
          name: 'SideNavItemProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      renderItem: {
        defaultValue: null,
        description: '',
        name: 'renderItem',
        parent: undefined,
        required: false,
        type: {
          name: '(props: any) => Element'
        }
      }
    },
    extends: []
  };
} catch (e) {}