function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Fragment, createElement } from 'react';
import PropTypes from "prop-types";
import { keysOf } from '../common';
import classNames from 'classnames';
import { EuiText } from '../text';
import { EuiTitle } from '../title/title';
import { EuiScreenReaderOnly } from '../accessibility';
import { EuiI18n } from '../i18n';
var colorToClassNameMap = {
  default: null,
  subdued: 'euiStat__title--subdued',
  primary: 'euiStat__title--primary',
  secondary: 'euiStat__title--secondary',
  danger: 'euiStat__title--danger',
  accent: 'euiStat__title--accent'
};
export var COLORS = keysOf(colorToClassNameMap);
var textAlignToClassNameMap = {
  left: 'euiStat--leftAligned',
  center: 'euiStat--centerAligned',
  right: 'euiStat--rightAligned'
};
export var isColorClass = function isColorClass(input) {
  return colorToClassNameMap.hasOwnProperty(input);
};
export var ALIGNMENTS = keysOf(textAlignToClassNameMap);
export var EuiStat = function EuiStat(_ref) {
  var children = _ref.children,
      className = _ref.className,
      description = _ref.description,
      _ref$isLoading = _ref.isLoading,
      isLoading = _ref$isLoading === void 0 ? false : _ref$isLoading,
      _ref$reverse = _ref.reverse,
      reverse = _ref$reverse === void 0 ? false : _ref$reverse,
      _ref$textAlign = _ref.textAlign,
      textAlign = _ref$textAlign === void 0 ? 'left' : _ref$textAlign,
      title = _ref.title,
      _ref$titleColor = _ref.titleColor,
      titleColor = _ref$titleColor === void 0 ? 'default' : _ref$titleColor,
      _ref$titleSize = _ref.titleSize,
      titleSize = _ref$titleSize === void 0 ? 'l' : _ref$titleSize,
      _ref$titleElement = _ref.titleElement,
      titleElement = _ref$titleElement === void 0 ? 'p' : _ref$titleElement,
      _ref$descriptionEleme = _ref.descriptionElement,
      descriptionElement = _ref$descriptionEleme === void 0 ? 'p' : _ref$descriptionEleme,
      rest = _objectWithoutProperties(_ref, ["children", "className", "description", "isLoading", "reverse", "textAlign", "title", "titleColor", "titleSize", "titleElement", "descriptionElement"]);

  var classes = classNames('euiStat', textAlignToClassNameMap[textAlign], className);
  var titleClasses = classNames('euiStat__title', isColorClass(titleColor) ? colorToClassNameMap[titleColor] : null, {
    'euiStat__title-isLoading': isLoading
  });
  var commonProps = {
    'aria-hidden': true
  };
  var descriptionDisplay = React.createElement(EuiText, {
    size: "s",
    className: "euiStat__description"
  }, createElement(descriptionElement, commonProps, description));
  var titlePropsWithColor = {
    'aria-hidden': true,
    style: {
      color: "".concat(titleColor)
    }
  };
  var titleChildren = isLoading ? '--' : title;
  var titleDisplay = isColorClass(titleColor) ? React.createElement(EuiTitle, {
    size: titleSize,
    className: titleClasses
  }, createElement(titleElement, commonProps, titleChildren)) : React.createElement(EuiTitle, {
    size: titleSize,
    className: titleClasses
  }, createElement(titleElement, titlePropsWithColor, titleChildren));
  var screenReader = React.createElement(EuiScreenReaderOnly, null, React.createElement("p", null, isLoading ? React.createElement(EuiI18n, {
    token: "euiStat.loadingText",
    default: "Statistic is loading"
  }) : React.createElement(Fragment, null, reverse ? "".concat(title, " ").concat(description) : "".concat(description, " ").concat(title))));
  var statDisplay = React.createElement(Fragment, null, !reverse && descriptionDisplay, titleDisplay, reverse && descriptionDisplay, typeof title === 'string' && typeof description === 'string' && screenReader);
  return React.createElement("div", _extends({
    className: classes
  }, rest), statDisplay, children);
};
EuiStat.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
     * Set the description (label) text
     */
  description: PropTypes.node.isRequired,

  /**
     * Will hide the title with an animation until false
     */
  isLoading: PropTypes.bool,

  /**
     * Flips the order of the description and title
     */
  reverse: PropTypes.bool,
  textAlign: PropTypes.oneOf(["left", "center", "right"]),

  /**
     * The (value) text
     */
  title: PropTypes.node.isRequired,

  /**
     * The color of the title text
     */
  titleColor: PropTypes.oneOfType([PropTypes.oneOf(["default", "subdued", "primary", "secondary", "danger", "accent"]).isRequired, PropTypes.string.isRequired]),

  /**
     * Size of the title. See EuiTitle for options ('s', 'm', 'l'... etc)
     */
  titleSize: PropTypes.oneOf(["xxxs", "xxs", "xs", "s", "m", "l"]),

  /**
     * HTML Element to be used for title
     */
  titleElement: PropTypes.string,

  /**
     * HTML Element to be used for description
     */
  descriptionElement: PropTypes.string
};

try {
  isColorClass.__docgenInfo = {
    description: '',
    displayName: 'isColorClass',
    methods: [],
    props: {},
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiStat.__docgenInfo = {
    description: '',
    displayName: 'EuiStat',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      description: {
        defaultValue: null,
        description: 'Set the description (label) text',
        name: 'description',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      isLoading: {
        defaultValue: {
          value: 'false'
        },
        description: 'Will hide the title with an animation until false',
        name: 'isLoading',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      reverse: {
        defaultValue: {
          value: 'false'
        },
        description: 'Flips the order of the description and title',
        name: 'reverse',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      textAlign: {
        defaultValue: {
          value: 'left'
        },
        description: '',
        name: 'textAlign',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'CardAlignment',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"center"'
          }]
        }
      },
      title: {
        defaultValue: null,
        description: 'The (value) text',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: true,
        type: {
          name: 'ReactNode'
        }
      },
      titleColor: {
        defaultValue: {
          value: 'default'
        },
        description: 'The color of the title text',
        name: 'titleColor',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      titleSize: {
        defaultValue: {
          value: 'l'
        },
        description: 'Size of the title. See EuiTitle for options (\'s\', \'m\', \'l\'... etc)',
        name: 'titleSize',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "xs" | "l" | "xxxs" | "xxs"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"xs"'
          }, {
            value: '"l"'
          }, {
            value: '"xxxs"'
          }, {
            value: '"xxs"'
          }]
        }
      },
      titleElement: {
        defaultValue: {
          value: 'p'
        },
        description: 'HTML Element to be used for title',
        name: 'titleElement',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      descriptionElement: {
        defaultValue: {
          value: 'p'
        },
        description: 'HTML Element to be used for description',
        name: 'descriptionElement',
        parent: {
          fileName: 'eui/src/components/stat/stat.tsx',
          name: 'EuiStatProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}