function _typeof(obj) { if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from "prop-types";
import { EuiButtonEmpty } from '../../button';
import { EuiContextMenuItem, EuiContextMenuPanel } from '../../context_menu';
import { EuiFlexGroup, EuiFlexItem } from '../../flex';
import { EuiPagination } from '../../pagination';
import { EuiPopover } from '../../popover';
import { EuiI18n } from '../../i18n';
export var EuiTablePagination =
/*#__PURE__*/
function (_Component) {
  _inherits(EuiTablePagination, _Component);

  function EuiTablePagination() {
    var _getPrototypeOf2;

    var _this;

    _classCallCheck(this, EuiTablePagination);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _possibleConstructorReturn(this, (_getPrototypeOf2 = _getPrototypeOf(EuiTablePagination)).call.apply(_getPrototypeOf2, [this].concat(args)));

    _defineProperty(_assertThisInitialized(_this), "state", {
      isPopoverOpen: false
    });

    _defineProperty(_assertThisInitialized(_this), "onButtonClick", function () {
      _this.setState({
        isPopoverOpen: !_this.state.isPopoverOpen
      });
    });

    _defineProperty(_assertThisInitialized(_this), "closePopover", function () {
      _this.setState({
        isPopoverOpen: false
      });
    });

    return _this;
  }

  _createClass(EuiTablePagination, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          activePage = _this$props.activePage,
          _this$props$itemsPerP = _this$props.itemsPerPage,
          itemsPerPage = _this$props$itemsPerP === void 0 ? 50 : _this$props$itemsPerP,
          _this$props$itemsPerP2 = _this$props.itemsPerPageOptions,
          itemsPerPageOptions = _this$props$itemsPerP2 === void 0 ? [10, 20, 50, 100] : _this$props$itemsPerP2,
          _this$props$hidePerPa = _this$props.hidePerPageOptions,
          hidePerPageOptions = _this$props$hidePerPa === void 0 ? false : _this$props$hidePerPa,
          _this$props$onChangeI = _this$props.onChangeItemsPerPage,
          onChangeItemsPerPage = _this$props$onChangeI === void 0 ? function () {} : _this$props$onChangeI,
          onChangePage = _this$props.onChangePage,
          pageCount = _this$props.pageCount,
          ariaControls = _this$props['aria-controls'],
          rest = _objectWithoutProperties(_this$props, ["activePage", "itemsPerPage", "itemsPerPageOptions", "hidePerPageOptions", "onChangeItemsPerPage", "onChangePage", "pageCount", "aria-controls"]);

      var button = React.createElement(EuiButtonEmpty, {
        size: "xs",
        color: "text",
        iconType: "arrowDown",
        iconSide: "right",
        "data-test-subj": "tablePaginationPopoverButton",
        onClick: this.onButtonClick
      }, React.createElement(EuiI18n, {
        token: "euiTablePagination.rowsPerPage",
        default: "Rows per page"
      }), ": ", itemsPerPage);
      var items = itemsPerPageOptions.map(function (itemsPerPageOption) {
        return React.createElement(EuiContextMenuItem, {
          key: itemsPerPageOption,
          icon: itemsPerPageOption === itemsPerPage ? 'check' : 'empty',
          onClick: function onClick() {
            _this2.closePopover();

            onChangeItemsPerPage(itemsPerPageOption);
          },
          "data-test-subj": "tablePagination-".concat(itemsPerPageOption, "-rows")
        }, React.createElement(EuiI18n, {
          token: "euiTablePagination.rowsPerPageOption",
          values: {
            rowsPerPage: itemsPerPageOption
          },
          default: "{rowsPerPage} rows"
        }));
      });
      var itemsPerPagePopover = React.createElement(EuiPopover, {
        button: button,
        isOpen: this.state.isPopoverOpen,
        closePopover: this.closePopover,
        panelPaddingSize: "none",
        withTitle: true,
        anchorPosition: "upRight"
      }, React.createElement(EuiContextMenuPanel, {
        items: items
      }));
      return React.createElement(EuiFlexGroup, {
        justifyContent: "spaceBetween",
        alignItems: "center",
        responsive: false
      }, React.createElement(EuiFlexItem, {
        grow: false
      }, hidePerPageOptions ? null : itemsPerPagePopover), React.createElement(EuiFlexItem, {
        grow: false
      }, React.createElement(EuiPagination, _extends({
        "aria-controls": ariaControls,
        pageCount: pageCount,
        activePage: activePage,
        onPageClick: onChangePage
      }, rest))));
    }
  }]);

  return EuiTablePagination;
}(Component);
EuiTablePagination.propTypes = {
  activePage: PropTypes.number,
  hidePerPageOptions: PropTypes.bool,
  itemsPerPage: PropTypes.number,
  itemsPerPageOptions: PropTypes.arrayOf(PropTypes.number.isRequired),
  onChangeItemsPerPage: PropTypes.func,
  onChangePage: PropTypes.func,
  pageCount: PropTypes.number,

  /**
     * id of the table being controlled
     */
  "aria-controls": PropTypes.string
};

try {
  EuiTablePagination.__docgenInfo = {
    description: '',
    displayName: 'EuiTablePagination',
    methods: [],
    props: {
      activePage: {
        defaultValue: null,
        description: '',
        name: 'activePage',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      hidePerPageOptions: {
        defaultValue: null,
        description: '',
        name: 'hidePerPageOptions',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      itemsPerPage: {
        defaultValue: null,
        description: '',
        name: 'itemsPerPage',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      itemsPerPageOptions: {
        defaultValue: null,
        description: '',
        name: 'itemsPerPageOptions',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number[]'
        }
      },
      onChangeItemsPerPage: {
        defaultValue: null,
        description: '',
        name: 'onChangeItemsPerPage',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ItemsPerPageChangeHandler'
        }
      },
      onChangePage: {
        defaultValue: null,
        description: '',
        name: 'onChangePage',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'PageChangeHandler'
        }
      },
      pageCount: {
        defaultValue: null,
        description: '',
        name: 'pageCount',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      'aria-controls': {
        defaultValue: null,
        description: 'id of the table being controlled',
        name: 'aria-controls',
        parent: {
          fileName: 'eui/src/components/table/table_pagination/table_pagination.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}