function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
export var EuiTableRow = function EuiTableRow(_ref) {
  var children = _ref.children,
      className = _ref.className,
      isSelected = _ref.isSelected,
      isSelectable = _ref.isSelectable,
      hasActions = _ref.hasActions,
      isExpandedRow = _ref.isExpandedRow,
      isExpandable = _ref.isExpandable,
      onClick = _ref.onClick,
      rest = _objectWithoutProperties(_ref, ["children", "className", "isSelected", "isSelectable", "hasActions", "isExpandedRow", "isExpandable", "onClick"]);

  var classes = classNames('euiTableRow', className, {
    'euiTableRow-isSelectable': isSelectable,
    'euiTableRow-isSelected': isSelected,
    'euiTableRow-hasActions': hasActions,
    'euiTableRow-isExpandedRow': isExpandedRow,
    'euiTableRow-isExpandable': isExpandable,
    'euiTableRow-isClickable': onClick
  });
  return React.createElement("tr", _extends({
    className: classes,
    onClick: onClick
  }, rest), children);
};
EuiTableRow.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
     * Indicates if the table has a single column of checkboxes for selecting
     * rows (affects mobile only)
     */
  isSelectable: PropTypes.bool,

  /**
     * Indicates the current row has been selected
     */
  isSelected: PropTypes.bool,

  /**
     * Indicates if the table has a dedicated column for icon-only actions
     * (affects mobile only)
     */
  hasActions: PropTypes.bool,

  /**
     * Indicates if the row will have an expanded row
     */
  isExpandable: PropTypes.bool,

  /**
     * Indicates if the row will be the expanded row
     */
  isExpandedRow: PropTypes.bool
};

try {
  EuiTableRow.__docgenInfo = {
    description: '',
    displayName: 'EuiTableRow',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isSelectable: {
        defaultValue: null,
        description: 'Indicates if the table has a single column of checkboxes for selecting\nrows (affects mobile only)',
        name: 'isSelectable',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isSelected: {
        defaultValue: null,
        description: 'Indicates the current row has been selected',
        name: 'isSelected',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      hasActions: {
        defaultValue: null,
        description: 'Indicates if the table has a dedicated column for icon-only actions\n(affects mobile only)',
        name: 'hasActions',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpandable: {
        defaultValue: null,
        description: 'Indicates if the row will have an expanded row',
        name: 'isExpandable',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      isExpandedRow: {
        defaultValue: null,
        description: 'Indicates if the row will be the expanded row',
        name: 'isExpandedRow',
        parent: {
          fileName: 'eui/src/components/table/table_row.tsx',
          name: 'EuiTableRowProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}