/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { useEuiTextDiff } from './text_diff';

try {
  useEuiTextDiff.__docgenInfo = {
    description: '',
    displayName: 'useEuiTextDiff',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      beforeText: {
        defaultValue: null,
        description: 'The starting string',
        name: 'beforeText',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      afterText: {
        defaultValue: null,
        description: 'The string used to compare against `beforeText`',
        name: 'afterText',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      insertComponent: {
        defaultValue: null,
        description: 'HTML element to wrap insertion differences.\nDefaults to `ins`',
        name: 'insertComponent',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ElementType<any>'
        }
      },
      deleteComponent: {
        defaultValue: null,
        description: 'HTML element to wrap deletion differences.\nDefaults to `del`',
        name: 'deleteComponent',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ElementType<any>'
        }
      },
      sameComponent: {
        defaultValue: null,
        description: 'HTML element to wrap text with no differences.\nDoesn\'t wrap with anything by default',
        name: 'sameComponent',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ElementType<any>'
        }
      },
      timeout: {
        defaultValue: null,
        description: 'Time in milliseconds. Passing a timeout of value \'0\' disables the timeout state',
        name: 'timeout',
        parent: {
          fileName: 'eui/src/components/text_diff/text_diff.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}