/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiToast } from './toast';
export { EuiGlobalToastList } from './global_toast_list';
export { EuiGlobalToastListItem } from './global_toast_list_item';

try {
  EuiToast.__docgenInfo = {
    description: '',
    displayName: 'EuiToast',
    methods: [],
    props: {
      title: {
        defaultValue: null,
        description: '',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/toast/toast.tsx',
          name: 'EuiToastProps'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      color: {
        defaultValue: null,
        description: '',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/toast/toast.tsx',
          name: 'EuiToastProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'Color',
          value: [{
            value: '"primary"'
          }, {
            value: '"warning"'
          }, {
            value: '"danger"'
          }, {
            value: '"success"'
          }]
        }
      },
      iconType: {
        defaultValue: null,
        description: '',
        name: 'iconType',
        parent: {
          fileName: 'eui/src/components/toast/toast.tsx',
          name: 'EuiToastProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      onClose: {
        defaultValue: null,
        description: '',
        name: 'onClose',
        parent: {
          fileName: 'eui/src/components/toast/toast.tsx',
          name: 'EuiToastProps'
        },
        required: false,
        type: {
          name: '() => void'
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiGlobalToastList.__docgenInfo = {
    description: '',
    displayName: 'EuiGlobalToastList',
    methods: [],
    props: {
      toasts: {
        defaultValue: null,
        description: '',
        name: 'toasts',
        parent: {
          fileName: 'eui/src/components/toast/global_toast_list.tsx',
          name: 'EuiGlobalToastListProps'
        },
        required: true,
        type: {
          name: 'Toast[]'
        }
      },
      dismissToast: {
        defaultValue: null,
        description: '',
        name: 'dismissToast',
        parent: {
          fileName: 'eui/src/components/toast/global_toast_list.tsx',
          name: 'EuiGlobalToastListProps'
        },
        required: true,
        type: {
          name: '(this: EuiGlobalToastList, toast: Toast) => void'
        }
      },
      toastLifeTimeMs: {
        defaultValue: null,
        description: '',
        name: 'toastLifeTimeMs',
        parent: {
          fileName: 'eui/src/components/toast/global_toast_list.tsx',
          name: 'EuiGlobalToastListProps'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      side: {
        defaultValue: null,
        description: 'Determines which side of the browser window the toasts should appear',
        name: 'side',
        parent: {
          fileName: 'eui/src/components/toast/global_toast_list.tsx',
          name: 'EuiGlobalToastListProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ButtonContentIconSide',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }]
        }
      },
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}

try {
  EuiGlobalToastListItem.__docgenInfo = {
    description: '',
    displayName: 'EuiGlobalToastListItem',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      isDismissed: {
        defaultValue: null,
        description: '',
        name: 'isDismissed',
        parent: {
          fileName: 'eui/src/components/toast/global_toast_list_item.tsx',
          name: 'EuiGlobalToastListItemProps'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      children: {
        defaultValue: null,
        description: 'ReactElement to render as this component\'s content',
        name: 'children',
        parent: undefined,
        required: false,
        type: {
          name: 'ReactElement'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}