/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiToggle, TYPES as TOGGLE_TYPES } from './toggle';

try {
  EuiToggle.__docgenInfo = {
    description: '',
    displayName: 'EuiToggle',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Defines a string value that labels the current element.\n@see aria-labelledby.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      checked: {
        defaultValue: null,
        description: 'Initial state of the toggle',
        name: 'checked',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      onChange: {
        defaultValue: null,
        description: 'For handling the onChange event of the input',
        name: 'onChange',
        parent: undefined,
        required: false,
        type: {
          name: '(event: ChangeEvent<HTMLInputElement>) => void'
        }
      },
      isDisabled: {
        defaultValue: null,
        description: '',
        name: 'isDisabled',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      name: {
        defaultValue: null,
        description: '',
        name: 'name',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: 'Determines the input type based on multiple or single item(s)',
        name: 'type',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: '"single" | "multi"',
          value: [{
            value: '"single"'
          }, {
            value: '"multi"'
          }]
        }
      },
      label: {
        defaultValue: null,
        description: 'What would typically be the input\'s label. Required for accessibility.',
        name: 'label',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      inputClassName: {
        defaultValue: null,
        description: 'Additional classNames for the input itself',
        name: 'inputClassName',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      value: {
        defaultValue: null,
        description: '',
        name: 'value',
        parent: undefined,
        required: false,
        type: {
          name: 'string | number'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}