/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiToolTip } from './tool_tip';
export { EuiIconTip } from './icon_tip';

try {
  EuiToolTip.__docgenInfo = {
    description: '',
    displayName: 'EuiToolTip',
    methods: [],
    props: {
      anchorClassName: {
        defaultValue: null,
        description: 'Passes onto the the trigger.',
        name: 'anchorClassName',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'The in-view trigger for your tooltip.',
        name: 'children',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: 'ReactElement'
        }
      },
      className: {
        defaultValue: null,
        description: 'Passes onto the tooltip itself, not the trigger.',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      content: {
        defaultValue: null,
        description: 'The main content of your tooltip.',
        name: 'content',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      delay: {
        defaultValue: null,
        description: 'Delay before showing tooltip. Good for repeatable items.',
        name: 'delay',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: 'enum',
          raw: 'ToolTipDelay',
          value: [{
            value: '"regular"'
          }, {
            value: '"long"'
          }]
        }
      },
      title: {
        defaultValue: null,
        description: 'An optional title for your tooltip.',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      id: {
        defaultValue: null,
        description: 'Unless you provide one, this will be randomly generated.',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      position: {
        defaultValue: null,
        description: 'Suggested position. If there is not enough room for it this will be changed.',
        name: 'position',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: true,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      onMouseOut: {
        defaultValue: null,
        description: 'If supplied, called when mouse movement causes the tool tip to be\nhidden.',
        name: 'onMouseOut',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLSpanElement, MouseEvent>) => void'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  EuiIconTip.__docgenInfo = {
    description: '',
    displayName: 'EuiIconTip',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: 'Passes onto the tooltip itself, not the trigger.',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      id: {
        defaultValue: null,
        description: 'Unless you provide one, this will be randomly generated.',
        name: 'id',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      title: {
        defaultValue: null,
        description: 'An optional title for your tooltip.',
        name: 'title',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      onMouseOut: {
        defaultValue: null,
        description: 'If supplied, called when mouse movement causes the tool tip to be\nhidden.',
        name: 'onMouseOut',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: '(event: MouseEvent<HTMLSpanElement, MouseEvent>) => void'
        }
      },
      anchorClassName: {
        defaultValue: null,
        description: 'Passes onto the the trigger.',
        name: 'anchorClassName',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      content: {
        defaultValue: null,
        description: 'The main content of your tooltip.',
        name: 'content',
        parent: {
          fileName: 'eui/src/components/tool_tip/tool_tip.tsx',
          name: 'Props'
        },
        required: false,
        type: {
          name: 'ReactNode'
        }
      },
      color: {
        defaultValue: null,
        description: 'The icon color.',
        name: 'color',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      type: {
        defaultValue: null,
        description: 'The icon type.',
        name: 'type',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'IconType'
        }
      },
      size: {
        defaultValue: null,
        description: 'The icon size.',
        name: 'size',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"s" | "m" | "l" | "xl" | "original" | "xxl"',
          value: [{
            value: '"s"'
          }, {
            value: '"m"'
          }, {
            value: '"l"'
          }, {
            value: '"xl"'
          }, {
            value: '"original"'
          }, {
            value: '"xxl"'
          }]
        }
      },
      'aria-label': {
        defaultValue: null,
        description: 'Explain what this icon means for screen readers.',
        name: 'aria-label',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      iconProps: {
        defaultValue: null,
        description: 'Pass certain props down to `EuiIcon`',
        name: 'iconProps',
        parent: {
          fileName: 'eui/src/components/tool_tip/icon_tip.tsx',
          name: 'EuiIconTipProps'
        },
        required: false,
        type: {
          name: 'Pick<EuiIconProps, "string" | "children" | "tabIndex" | "fill" | "color" | "size" | "className" | "aria-label" | "data-test-subj" | "href" | "onClick" | "media" | ... 459 more ... | "onIconLoad"> & { ...; }'
        }
      },
      delay: {
        defaultValue: null,
        description: '',
        name: 'delay',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipDelay',
          value: [{
            value: '"regular"'
          }, {
            value: '"long"'
          }]
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      }
    },
    extends: []
  };
} catch (e) {}