function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) { return; } var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEuiTour } from './useEuiTour';
import PropTypes from "prop-types";
export var EuiTour = function EuiTour(_ref) {
  var children = _ref.children,
      steps = _ref.steps,
      initialState = _ref.initialState;

  var _useEuiTour = useEuiTour(steps, initialState),
      _useEuiTour2 = _slicedToArray(_useEuiTour, 3),
      stepProps = _useEuiTour2[0],
      actions = _useEuiTour2[1],
      state = _useEuiTour2[2];

  return children(stepProps, actions, state);
};
EuiTour.propTypes = {
  children: PropTypes.func.isRequired,
  steps: PropTypes.arrayOf(PropTypes.any.isRequired).isRequired,
  initialState: PropTypes.shape({
    currentTourStep: PropTypes.number.isRequired,
    isTourActive: PropTypes.bool.isRequired,
    tourPopoverWidth: PropTypes.number.isRequired,
    tourSubtitle: PropTypes.string.isRequired
  }).isRequired
};

try {
  EuiTour.__docgenInfo = {
    description: '',
    displayName: 'EuiTour',
    methods: [],
    props: {
      steps: {
        defaultValue: null,
        description: '',
        name: 'steps',
        parent: {
          fileName: 'eui/src/components/tour/tour.tsx',
          name: 'EuiTourProps'
        },
        required: true,
        type: {
          name: 'EuiStatelessTourStep[]'
        }
      },
      initialState: {
        defaultValue: null,
        description: '',
        name: 'initialState',
        parent: {
          fileName: 'eui/src/components/tour/tour.tsx',
          name: 'EuiTourProps'
        },
        required: true,
        type: {
          name: 'EuiTourState'
        }
      }
    },
    extends: []
  };
} catch (e) {}