/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { EuiTreeView } from './tree_view';

try {
  EuiTreeView.__docgenInfo = {
    description: '',
    displayName: 'EuiTreeView',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: '',
        name: 'className',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      'data-test-subj': {
        defaultValue: null,
        description: '',
        name: 'data-test-subj',
        parent: {
          fileName: 'eui/src/components/common.ts',
          name: 'CommonProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      },
      display: {
        defaultValue: null,
        description: 'Optionally use a variation with smaller text and icon sizes',
        name: 'display',
        parent: undefined,
        required: false,
        type: {
          name: 'enum',
          raw: 'EuiTreeViewDisplayOptions',
          value: [{
            value: '"default"'
          }, {
            value: '"compressed"'
          }]
        }
      },
      items: {
        defaultValue: null,
        description: 'An array of EuiTreeViewNodes',
        name: 'items',
        parent: undefined,
        required: true,
        type: {
          name: 'Node[]'
        }
      },
      expandByDefault: {
        defaultValue: null,
        description: 'Set all items to open on initial load',
        name: 'expandByDefault',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      showExpansionArrows: {
        defaultValue: null,
        description: 'Display expansion arrows next to all itmes\nthat contain children',
        name: 'showExpansionArrows',
        parent: undefined,
        required: false,
        type: {
          name: 'boolean'
        }
      },
      'aria-label': {
        defaultValue: null,
        description: '',
        name: 'aria-label',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      },
      'aria-labelledby': {
        defaultValue: null,
        description: '',
        name: 'aria-labelledby',
        parent: undefined,
        required: true,
        type: {
          name: 'string'
        }
      }
    },
    extends: ['DOMAttributes']
  };
} catch (e) {}