/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { accessibleClickKeys } from './accessible_click_keys';
export { cascadingMenuKeys } from './cascading_menu_keys';
export { comboBoxKeys } from './combo_box_keys';
export { htmlIdGenerator } from './html_id_generator';

try {
  htmlIdGenerator.__docgenInfo = {
    description: 'This function returns a function to generate ids.\nThis can be used to generate unique, but predictable ids to pair labels\nwith their inputs. It takes an optional prefix as a parameter. If you don\'t\nspecify it, it generates a random id prefix. If you specify a custom prefix\nit should begin with an letter to be HTML4 compliant.',
    displayName: 'htmlIdGenerator',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}