/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { isColorDark } from './is_color_dark';
export { isValidHex } from './is_valid_hex';
export { hexToHsv } from './hex_to_hsv';
export { hexToRgb } from './hex_to_rgb';
export { hsvToHex } from './hsv_to_hex';
export { hsvToRgb } from './hsv_to_rgb';
export { rgbToHex } from './rgb_to_hex';
export { rgbToHsv } from './rgb_to_hsv';
export { calculateContrast, calculateLuminance } from './luminance_and_contrast';
export { VISUALIZATION_COLORS, DEFAULT_VISUALIZATION_COLOR } from './visualization_colors';
export { colorPalette } from './color_palette';
export { euiPaletteForLightBackground, euiPaletteForDarkBackground, euiPaletteColorBlind, euiPaletteColorBlindBehindText, euiPaletteForStatus, euiPaletteForTemperature, euiPaletteComplimentary, euiPaletteNegative, euiPalettePositive, euiPaletteCool, euiPaletteWarm, euiPaletteGray } from './eui_palettes';
export {} from './color_types';

try {
  isColorDark.__docgenInfo = {
    description: 'This function calculates if the specified color is "dark", which usually means\nyou need light text if you use it as a background color to fulfill WCAG contrast\nrequirement.\nThe color must be specified via its red, green and blue value in the range of\n0 to 255.\nThe formula is based on this Stackoverflow answer: https://stackoverflow.com/a/3943023\nwhich itself is based upon the WCAG recommendation for color contrast.\n@param red The red component in the range 0 to 255\n@param green The green component in the range 0 to 255\n@param blue The blue component in the range 0 to 255\n@returns True if the color is dark, false otherwise.',
    displayName: 'isColorDark',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  isValidHex.__docgenInfo = {
    description: '',
    displayName: 'isValidHex',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  hexToHsv.__docgenInfo = {
    description: '',
    displayName: 'hexToHsv',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  hexToRgb.__docgenInfo = {
    description: '',
    displayName: 'hexToRgb',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  hsvToHex.__docgenInfo = {
    description: '',
    displayName: 'hsvToHex',
    methods: [],
    props: {
      h: {
        defaultValue: null,
        description: '',
        name: 'h',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      s: {
        defaultValue: null,
        description: '',
        name: 's',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      v: {
        defaultValue: null,
        description: '',
        name: 'v',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  hsvToRgb.__docgenInfo = {
    description: '',
    displayName: 'hsvToRgb',
    methods: [],
    props: {
      h: {
        defaultValue: null,
        description: '',
        name: 'h',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      s: {
        defaultValue: null,
        description: '',
        name: 's',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      v: {
        defaultValue: null,
        description: '',
        name: 'v',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  rgbToHex.__docgenInfo = {
    description: '',
    displayName: 'rgbToHex',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  rgbToHsv.__docgenInfo = {
    description: '',
    displayName: 'rgbToHsv',
    methods: [],
    props: {
      r: {
        defaultValue: null,
        description: '',
        name: 'r',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'RGB'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      g: {
        defaultValue: null,
        description: '',
        name: 'g',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'RGB'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      b: {
        defaultValue: null,
        description: '',
        name: 'b',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'RGB'
        },
        required: true,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  colorPalette.__docgenInfo = {
    description: 'This function takes an array of colors and returns an array of interpolated\ncolors based on the number of steps/len needed for use in UI elements such as charts.\nDerived from https://github.com/gka/palettes (Unlicensed)',
    displayName: 'colorPalette',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteColorBlind.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteColorBlind',
    methods: [],
    props: {
      rotations: {
        defaultValue: null,
        description: 'How many variations of the series is needed',
        name: 'rotations',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      order: {
        defaultValue: null,
        description: 'Order similar colors as `group`s or just `append` each variation',
        name: 'order',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"append" | "group"',
          value: [{
            value: '"append"'
          }, {
            value: '"group"'
          }]
        }
      },
      direction: {
        defaultValue: null,
        description: 'Specifies if the direction of the color variations',
        name: 'direction',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"both" | "lighter" | "darker"',
          value: [{
            value: '"both"'
          }, {
            value: '"lighter"'
          }, {
            value: '"darker"'
          }]
        }
      },
      sortBy: {
        defaultValue: null,
        description: 'Use the default sort order, or re-sort them based on the color wheel (natural)',
        name: 'sortBy',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"default" | "natural"',
          value: [{
            value: '"default"'
          }, {
            value: '"natural"'
          }]
        }
      },
      sortShift: {
        defaultValue: null,
        description: 'Shift the sorting order by a certain number when used in conjunction with `\'natural\'` `sortBy`.\nDefaults to a number close to green.',
        name: 'sortShift',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  euiPaletteColorBlindBehindText.__docgenInfo = {
    description: 'Color blind palette with text is meant for use when text is applied on top of the color.\nIt increases the brightness of the color to give the text more contrast.',
    displayName: 'euiPaletteColorBlindBehindText',
    methods: [],
    props: {
      rotations: {
        defaultValue: null,
        description: 'How many variations of the series is needed',
        name: 'rotations',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      order: {
        defaultValue: null,
        description: 'Order similar colors as `group`s or just `append` each variation',
        name: 'order',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"append" | "group"',
          value: [{
            value: '"append"'
          }, {
            value: '"group"'
          }]
        }
      },
      direction: {
        defaultValue: null,
        description: 'Specifies if the direction of the color variations',
        name: 'direction',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"both" | "lighter" | "darker"',
          value: [{
            value: '"both"'
          }, {
            value: '"lighter"'
          }, {
            value: '"darker"'
          }]
        }
      },
      sortBy: {
        defaultValue: null,
        description: 'Use the default sort order, or re-sort them based on the color wheel (natural)',
        name: 'sortBy',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"default" | "natural"',
          value: [{
            value: '"default"'
          }, {
            value: '"natural"'
          }]
        }
      },
      sortShift: {
        defaultValue: null,
        description: 'Shift the sorting order by a certain number when used in conjunction with `\'natural\'` `sortBy`.\nDefaults to a number close to green.',
        name: 'sortShift',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  euiPaletteForStatus.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteForStatus',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteForTemperature.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteForTemperature',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteComplimentary.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteComplimentary',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteNegative.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteNegative',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPalettePositive.__docgenInfo = {
    description: '',
    displayName: 'euiPalettePositive',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteCool.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteCool',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteWarm.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteWarm',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteGray.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteGray',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}