/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
// Export all keys under a `keys` named variable
import * as keys from './keys';
export { keys };
export { accessibleClickKeys, cascadingMenuKeys, comboBoxKeys, htmlIdGenerator } from './accessibility';
export { LEFT_ALIGNMENT, RIGHT_ALIGNMENT, CENTER_ALIGNMENT } from './alignment';
export { isColorDark, isValidHex, calculateContrast, calculateLuminance, hexToHsv, hexToRgb, hsvToHex, hsvToRgb, rgbToHex, rgbToHsv, VISUALIZATION_COLORS, DEFAULT_VISUALIZATION_COLOR, colorPalette, euiPaletteForLightBackground, euiPaletteForDarkBackground, euiPaletteColorBlind, euiPaletteColorBlindBehindText, euiPaletteForStatus, euiPaletteForTemperature, euiPaletteComplimentary, euiPaletteNegative, euiPalettePositive, euiPaletteCool, euiPaletteWarm, euiPaletteGray } from './color';
export { useColorPickerState, useColorStopsState } from './color_picker';
export { copyToClipboard } from './copy_to_clipboard';
export { formatAuto, formatBoolean, formatDate, formatNumber, formatText, dateFormatAliases } from './format';
export { isEvenlyDivisibleBy, isWithinRange } from './number';
export { Pager } from './paging';
export { Random } from './random';
export { getSecureRelForTarget } from './security';
export { toInitials } from './string';
export { PropertySortType, SortDirectionType, SortDirection, SortableProperties, Comparators } from './sort';
export { calculatePopoverPosition, findPopoverPosition } from './popover';
export { getDurationAndPerformOnFrame, getTransitionTimings, getWaitDuration, performOnFrame } from './transition';
export { EuiWindowEvent } from './window_event';
export { useCombinedRefs, useDependentState } from './hooks';

try {
  htmlIdGenerator.__docgenInfo = {
    description: 'This function returns a function to generate ids.\nThis can be used to generate unique, but predictable ids to pair labels\nwith their inputs. It takes an optional prefix as a parameter. If you don\'t\nspecify it, it generates a random id prefix. If you specify a custom prefix\nit should begin with an letter to be HTML4 compliant.',
    displayName: 'htmlIdGenerator',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  isColorDark.__docgenInfo = {
    description: 'This function calculates if the specified color is "dark", which usually means\nyou need light text if you use it as a background color to fulfill WCAG contrast\nrequirement.\nThe color must be specified via its red, green and blue value in the range of\n0 to 255.\nThe formula is based on this Stackoverflow answer: https://stackoverflow.com/a/3943023\nwhich itself is based upon the WCAG recommendation for color contrast.\n@param red The red component in the range 0 to 255\n@param green The green component in the range 0 to 255\n@param blue The blue component in the range 0 to 255\n@returns True if the color is dark, false otherwise.',
    displayName: 'isColorDark',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  isValidHex.__docgenInfo = {
    description: '',
    displayName: 'isValidHex',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  hexToHsv.__docgenInfo = {
    description: '',
    displayName: 'hexToHsv',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  hexToRgb.__docgenInfo = {
    description: '',
    displayName: 'hexToRgb',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  hsvToHex.__docgenInfo = {
    description: '',
    displayName: 'hsvToHex',
    methods: [],
    props: {
      h: {
        defaultValue: null,
        description: '',
        name: 'h',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      s: {
        defaultValue: null,
        description: '',
        name: 's',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      v: {
        defaultValue: null,
        description: '',
        name: 'v',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  hsvToRgb.__docgenInfo = {
    description: '',
    displayName: 'hsvToRgb',
    methods: [],
    props: {
      h: {
        defaultValue: null,
        description: '',
        name: 'h',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      s: {
        defaultValue: null,
        description: '',
        name: 's',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      v: {
        defaultValue: null,
        description: '',
        name: 'v',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'HSV'
        },
        required: true,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  rgbToHex.__docgenInfo = {
    description: '',
    displayName: 'rgbToHex',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  rgbToHsv.__docgenInfo = {
    description: '',
    displayName: 'rgbToHsv',
    methods: [],
    props: {
      r: {
        defaultValue: null,
        description: '',
        name: 'r',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'RGB'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      g: {
        defaultValue: null,
        description: '',
        name: 'g',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'RGB'
        },
        required: true,
        type: {
          name: 'number'
        }
      },
      b: {
        defaultValue: null,
        description: '',
        name: 'b',
        parent: {
          fileName: 'eui/src/services/color/color_types.ts',
          name: 'RGB'
        },
        required: true,
        type: {
          name: 'number'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  colorPalette.__docgenInfo = {
    description: 'This function takes an array of colors and returns an array of interpolated\ncolors based on the number of steps/len needed for use in UI elements such as charts.\nDerived from https://github.com/gka/palettes (Unlicensed)',
    displayName: 'colorPalette',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteColorBlind.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteColorBlind',
    methods: [],
    props: {
      rotations: {
        defaultValue: null,
        description: 'How many variations of the series is needed',
        name: 'rotations',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      order: {
        defaultValue: null,
        description: 'Order similar colors as `group`s or just `append` each variation',
        name: 'order',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"append" | "group"',
          value: [{
            value: '"append"'
          }, {
            value: '"group"'
          }]
        }
      },
      direction: {
        defaultValue: null,
        description: 'Specifies if the direction of the color variations',
        name: 'direction',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"both" | "lighter" | "darker"',
          value: [{
            value: '"both"'
          }, {
            value: '"lighter"'
          }, {
            value: '"darker"'
          }]
        }
      },
      sortBy: {
        defaultValue: null,
        description: 'Use the default sort order, or re-sort them based on the color wheel (natural)',
        name: 'sortBy',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"default" | "natural"',
          value: [{
            value: '"default"'
          }, {
            value: '"natural"'
          }]
        }
      },
      sortShift: {
        defaultValue: null,
        description: 'Shift the sorting order by a certain number when used in conjunction with `\'natural\'` `sortBy`.\nDefaults to a number close to green.',
        name: 'sortShift',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  euiPaletteColorBlindBehindText.__docgenInfo = {
    description: 'Color blind palette with text is meant for use when text is applied on top of the color.\nIt increases the brightness of the color to give the text more contrast.',
    displayName: 'euiPaletteColorBlindBehindText',
    methods: [],
    props: {
      rotations: {
        defaultValue: null,
        description: 'How many variations of the series is needed',
        name: 'rotations',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      order: {
        defaultValue: null,
        description: 'Order similar colors as `group`s or just `append` each variation',
        name: 'order',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"append" | "group"',
          value: [{
            value: '"append"'
          }, {
            value: '"group"'
          }]
        }
      },
      direction: {
        defaultValue: null,
        description: 'Specifies if the direction of the color variations',
        name: 'direction',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"both" | "lighter" | "darker"',
          value: [{
            value: '"both"'
          }, {
            value: '"lighter"'
          }, {
            value: '"darker"'
          }]
        }
      },
      sortBy: {
        defaultValue: null,
        description: 'Use the default sort order, or re-sort them based on the color wheel (natural)',
        name: 'sortBy',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'enum',
          raw: '"default" | "natural"',
          value: [{
            value: '"default"'
          }, {
            value: '"natural"'
          }]
        }
      },
      sortShift: {
        defaultValue: null,
        description: 'Shift the sorting order by a certain number when used in conjunction with `\'natural\'` `sortBy`.\nDefaults to a number close to green.',
        name: 'sortShift',
        parent: {
          fileName: 'eui/src/services/color/eui_palettes.ts',
          name: 'EuiPaletteColorBlindProps'
        },
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  euiPaletteForStatus.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteForStatus',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteForTemperature.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteForTemperature',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteComplimentary.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteComplimentary',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteNegative.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteNegative',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPalettePositive.__docgenInfo = {
    description: '',
    displayName: 'euiPalettePositive',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteCool.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteCool',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteWarm.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteWarm',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  euiPaletteGray.__docgenInfo = {
    description: '',
    displayName: 'euiPaletteGray',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  useColorPickerState.__docgenInfo = {
    description: '',
    displayName: 'useColorPickerState',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  copyToClipboard.__docgenInfo = {
    description: '',
    displayName: 'copyToClipboard',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  formatAuto.__docgenInfo = {
    description: '',
    displayName: 'formatAuto',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  getSecureRelForTarget.__docgenInfo = {
    description: '',
    displayName: 'getSecureRelForTarget',
    methods: [],
    props: {
      href: {
        defaultValue: null,
        description: '',
        name: 'href',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      target: {
        defaultValue: null,
        description: '',
        name: 'target',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      },
      rel: {
        defaultValue: null,
        description: '',
        name: 'rel',
        parent: undefined,
        required: false,
        type: {
          name: 'string'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  SortableProperties.__docgenInfo = {
    description: 'Stores sort information for a set of SortableProperties, including which property is currently being sorted on, as\nwell as the last sort order for each property.',
    displayName: 'SortableProperties',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  calculatePopoverPosition.__docgenInfo = {
    description: 'Determine the best position for a popover that avoids clipping by the window view port.\n@param anchorBounds - getBoundingClientRect() of the node the popover is tethered to (e.g. a button).\n@param popoverBounds - getBoundingClientRect() of the popover node (e.g. the tooltip).\n@param requestedPosition - Position the user wants. One of ["top", "right", "bottom", "left"]\n@param buffer - The space between the wrapper and the popover. Also the minimum space between the\npopover and the window.\n@param positions - List of acceptable positions. Defaults to ["top", "right", "bottom", "left"].\n@returns With properties position (one of ["top", "right", "bottom", "left"]), left, top, width, and height.',
    displayName: 'calculatePopoverPosition',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  findPopoverPosition.__docgenInfo = {
    description: 'Calculates the absolute positioning (relative to document.body) to place a popover element\n@param anchor Element to anchor the popover to\n@param popover Element containing the popover content\n@param position Position the user wants. One of ["top", "right", "bottom", "left"]\n@param forcePosition If true, use only the provided `position` value and don\'t try any other position\n@param align Cross-axis alignment. One of ["top", "right", "bottom", "left"]\n@param buffer Minimum distance between the popover and the bounding container\n@param offset Distance between the popover and the anchor\n@param allowCrossAxis Whether to allow the popover to be positioned on the cross-axis\n@param container Element the popover must be constrained to fit within\n@param arrowConfig If\npresent, describes the size & constraints for an arrow element, and the\nfunction return value will include an `arrow` param with position details\n@returns absolute page coordinates for the\npopover, and the placement\'s relation to the anchor or undefined\nthere\'s no room.',
    displayName: 'findPopoverPosition',
    methods: [],
    props: {
      anchor: {
        defaultValue: null,
        description: '',
        name: 'anchor',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: true,
        type: {
          name: 'HTMLElement'
        }
      },
      popover: {
        defaultValue: null,
        description: '',
        name: 'popover',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: true,
        type: {
          name: 'HTMLElement'
        }
      },
      align: {
        defaultValue: null,
        description: '',
        name: 'align',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      position: {
        defaultValue: null,
        description: '',
        name: 'position',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: true,
        type: {
          name: 'enum',
          raw: 'ToolTipPositions',
          value: [{
            value: '"left"'
          }, {
            value: '"right"'
          }, {
            value: '"top"'
          }, {
            value: '"bottom"'
          }]
        }
      },
      forcePosition: {
        defaultValue: null,
        description: '',
        name: 'forcePosition',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      buffer: {
        defaultValue: null,
        description: '',
        name: 'buffer',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      offset: {
        defaultValue: null,
        description: '',
        name: 'offset',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'number'
        }
      },
      allowCrossAxis: {
        defaultValue: null,
        description: '',
        name: 'allowCrossAxis',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      },
      container: {
        defaultValue: null,
        description: '',
        name: 'container',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'HTMLElement'
        }
      },
      arrowConfig: {
        defaultValue: null,
        description: '',
        name: 'arrowConfig',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: '{ arrowWidth: number; arrowBuffer: number; }'
        }
      },
      returnBoundingBox: {
        defaultValue: null,
        description: '',
        name: 'returnBoundingBox',
        parent: {
          fileName: 'eui/src/services/popover/popover_positioning.ts',
          name: 'FindPopoverPositionArgs'
        },
        required: false,
        type: {
          name: 'boolean'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  getTransitionTimings.__docgenInfo = {
    description: '',
    displayName: 'getTransitionTimings',
    methods: [],
    props: {
      className: {
        defaultValue: null,
        description: 'Returns the value of element\'s class content attribute. Can be set to change it.',
        name: 'className',
        parent: {
          fileName: 'eui/node_modules/typescript/lib/lib.dom.d.ts',
          name: 'Element'
        },
        required: true,
        type: {
          name: 'string'
        }
      },
      children: {
        defaultValue: null,
        description: 'Returns the child elements.',
        name: 'children',
        parent: {
          fileName: 'eui/node_modules/typescript/lib/lib.dom.d.ts',
          name: 'ParentNode'
        },
        required: true,
        type: {
          name: 'HTMLCollection'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  getWaitDuration.__docgenInfo = {
    description: '',
    displayName: 'getWaitDuration',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  EuiWindowEvent.__docgenInfo = {
    description: '',
    displayName: 'EuiWindowEvent',
    methods: [],
    props: {
      event: {
        defaultValue: null,
        description: '',
        name: 'event',
        parent: {
          fileName: 'eui/src/services/window_event/window_event.ts',
          name: 'Props'
        },
        required: true,
        type: {
          name: 'E'
        }
      },
      handler: {
        defaultValue: null,
        description: '',
        name: 'handler',
        parent: {
          fileName: 'eui/src/services/window_event/window_event.ts',
          name: 'Props'
        },
        required: true,
        type: {
          name: '(this: Window, ev: WindowEventMap[E]) => any'
        }
      }
    },
    extends: []
  };
} catch (e) {}

try {
  useCombinedRefs.__docgenInfo = {
    description: '',
    displayName: 'useCombinedRefs',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}