/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
export { requiredProps } from './required_props';
export { takeMountedSnapshot } from './take_mounted_snapshot';
export { findTestSubject } from './find_test_subject';
export { startThrowingReactWarnings, stopThrowingReactWarnings } from './react_warnings';
export { sleep } from './sleep';

try {
  takeMountedSnapshot.__docgenInfo = {
    description: 'Use this function to generate a Jest snapshot of components that have been fully rendered\nusing Enzyme\'s `mount` method. Typically, a mounted component will result in a snapshot\ncontaining both React components and HTML elements. This function removes the React components,\nleaving only HTML elements in the snapshot.',
    displayName: 'takeMountedSnapshot',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}

try {
  sleep.__docgenInfo = {
    description: '',
    displayName: 'sleep',
    methods: [],
    props: {},
    extends: []
  };
} catch (e) {}